<?php

namespace App\Http\Controllers\API\Company;

use App\Domain\Core\Models\Administration\User;
use App\Domain\Job\Models\Job;
use App\Domain\Job\Models\JobApply;
use App\Domain\Service\Models\Service;
use App\Http\Controllers\API\ApiController;
use App\Http\Resources\API\Job\JobResource;
use App\Http\Resources\API\Job\OfferResource;
use App\Http\Resources\API\Job\JobApplyResource;
use Arr;
use Illuminate\Http\Request;

class CompanyController extends ApiController
{
    public function companies(Request $request)
    {
        $jobs = User::role('company')->active()->get();

        return $this->sendResponse(
            JobResource::paginate($jobs),
            __('Jobs retrieved Successfully')
        );
    }
}
