<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class SubmitFormApiController extends Controller
{
    const ANIME_CAMPAIGN_ID = 16041;
    const LEADS_DIGGERS_LINK_ID = 108;
    const ANIME_KEY = "TVRNek5qWmZOekl4WHpFek16WTJYdz09";
    const ANIME_PASSWORD = "0EqyCtjrpc";
    const ANIME_URL = "https://tracker.trackedtomouegde.com/repost.php?act=register";
    const LEADS_DIGGERS_URL = "https://tracking.leadsdiggers.com/api/v3/integration?api_token=0NBu8CIqKi77nQO7bWMec7mJELGwO2EHHI0q5QslgnssDEm0Q2SrMpALeVEV";

    const CLCKSON_URL = "https://clckson-api.com/api/v2/leads";
    const CLCKSON_API_KEY = "CE211EF6-B151-F7C6-1403-F7A7CE3E98AD";

    public function SubmitForm(Request $request)
    {
        $country = $request->input('country');

        // Generate a unique hash for the submission
        $submissionHash = md5($request->input('phone') . $request->input('email'));

        // Retrieve the hash from the session to check for retries
        $previousHash = session('last_submission_hash');

        // If the current hash matches the previous hash, mark as a retry
        $isRetry = $previousHash === $submissionHash;

        $validator = Validator::make($request->all(), [
            'first_name' => 'required|string',
            'last_name' => 'required|string',
            'email' => 'required|email',
            'phone' => 'required|string',
            'country_code' => 'required|string',
            'country_name' => 'required|string',
        ]);

        if ($validator->fails()) {
            return $this->apiResponse(false, googleTrans($validator->errors()->first(), countryLang($country)));
        }

        // Update session with the current hash
        session(['last_submission_hash' => $submissionHash]);

        $countryRatios = [
            'DE' => ['anime' => 0, 'leads_diggers' => 0, 'clckson' => 100],
            'de' => ['anime' => 0, 'leads_diggers' => 0, 'clckson' => 100],
            'ZA' => ['anime' => 0, 'leads_diggers' => 0, 'clckson' => 100],
            'za' => ['anime' => 0, 'leads_diggers' => 0, 'clckson' => 100],
            
            
            
        ];

        $defaultRatios = ['anime' => 100, 'leads_diggers' => 0, 'clckson' => 0];

        $ratios = $countryRatios[$request->input('country_name')] ?? $defaultRatios;

        $endpoints = [
            ['type' => 'anime', 'percentage' => $ratios['anime']],
            ['type' => 'leads_diggers', 'percentage' => $ratios['leads_diggers']],
            ['type' => 'clckson', 'percentage' => $ratios['clckson']],
        ];

        $random = mt_rand(1, 100);
        $selectedEndpoint = null;
        $cumulativePercentage = 0;

        foreach ($endpoints as $endpoint) {
            $cumulativePercentage += $endpoint['percentage'];
            if ($random <= $cumulativePercentage) {
                $selectedEndpoint = $endpoint;
                break;
            }
        }

        try {
            switch ($selectedEndpoint['type']) {
                case 'anime':
                    return $this->handleAnimeAPI($country, $isRetry, $request);
                case 'leads_diggers':
                    return $this->handleLeadsDiggersAPI($country, $isRetry, $request);
                case 'clckson':
                    return $this->handleClcksonAPI($country, $isRetry, $request);
                default:
                    throw new \Exception('Invalid endpoint selected');
            }
        } catch (\Exception $e) {
            \Log::error('API Request Failed', ['error' => $e->getMessage(), 'trace' => $e->getTrace()]);
            return $this->apiResponse(false, 'An unexpected error occurred. Please try again later.', null, null, null, 500);
        }
    }

    private function handleAnimeAPI($country, $isRetry, Request $request)
    {
        if ($isRetry && $this->hasRetryFlag($request, 'anime')) {
            return $this->apiResponse(false, 'Anime API already retried.', null, null, null, 400);
        }

        list($firstname, $lastname, $email, $phone, $country_code, $country_name, $ip, $language, $pageName) = $this->AllData($request);

        $request_data = [
            'ApiKey' => self::ANIME_KEY,
            'ApiPassword' => self::ANIME_PASSWORD,
            'Email' => $email,
            'FirstName' => $firstname,
            'LastName' => $lastname,
            'IP' => $ip,
            'CampaignID' => self::ANIME_CAMPAIGN_ID,
            'PhoneNumber' => $country_code . $phone,
            'Page' => $pageName,
            'brand' => $pageName,
            'Language' => $language,
        ];

        $response = Http::asForm()->post(self::ANIME_URL, $request_data);

        if ($response->successful()) {
            $data = $response->json();

            if (isset($data['ret_code'])) {
                switch ($data['ret_code']) {
                    case "200":
                        return $this->apiResponse(true, null, null, route('thank-you', [
                            'country' => $country,
                            'redirect_url' => urlencode($data['url']),
                        ]));
                    case "404":
                        $message = match ($data['ret_message']) {
                            "Invalid Phone" => googleTrans('Invalid Phone', countryLang($country)),
                            "Invalid Email" => googleTrans('Invalid Email', countryLang($country)),
                            "No brand found" => googleTrans('No brand found', countryLang($country)),
                            default => googleTrans('Unknown error', countryLang($country)),
                        };
                        return response()->json(['success' => false, 'message' => googleTrans($message, countryLang($country)), 'data' => null], 200);
                    case "409":
                        return response()->json(['success' => false, 'type' => 'duplicate', 'message' => googleTrans('Duplicate Lead!', countryLang($country)), 'data' => null], 200);
                    case "201":
                        return $this->apiResponse(false, googleTrans('Brand is closed now', countryLang($country)), 'brand_closed', url(countryRedirectOnError($country)), null, 200);

                }
            }
        }

        return $this->apiResponse(false, $response->body(), null, null, null, $response->status());
    }

    private function handleLeadsDiggersAPI($country, $isRetry, Request $request)
    {

        list($firstname, $lastname, $email, $phone, $country_code, $country_name, $ip, $language, $pageName) = $this->AllData($request);

        $request_data = [
            'link_id' =>  self::LEADS_DIGGERS_LINK_ID,
            'email' => $email,
            'fname' => $firstname . ' ' . $lastname,
            'ip' => $ip,
            'fullphone' => '+' . $country_code . $phone,
            'source' => $pageName,
            'country' => Str::upper($country_name),
            'language' => $language,
        ];

        $response = Http::asForm()->post(self::LEADS_DIGGERS_URL, $request_data);

        if ($response->successful()) {
            $data = $response->json();

            if ($data['success']) {
                return $this->apiResponse(true, null, null, route('thank-you', [
                    'country' => $country,
                    'redirect_url' => urlencode($data['autologin']),
                ]));
            }
        }

        $this->setRetryFlag($request, 'leads_diggers');
        return $this->handleAnimeAPI($country, true, $request);
    }
    private function handleClcksonAPI($country, $isRetry, Request $request)
    {
        if ($isRetry && $this->hasRetryFlag($request, 'clckson')) {
            return response()->json([
                'success' => false,
                'message' => googleTrans('Clckson API already retried.', countryLang($country)),
                'data' => null
            ], 200);
        }

        list($firstname, $lastname, $email, $phone, $country_code, $country_name, $ip, $language, $pageName) = $this->AllData($request);

        // Generate a random password if not provided
        // Generate a password that only contains letters and numbers
        $password = $request->input('password', function() {
            $length = 10;
            $uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
            $lowercase = 'abcdefghijklmnopqrstuvwxyz';
            $numbers = '0123456789';

            $password = '';
            // Ensure at least one uppercase
            $password .= $uppercase[rand(0, strlen($uppercase) - 1)];
            // Ensure at least one lowercase
            $password .= $lowercase[rand(0, strlen($lowercase) - 1)];
            // Ensure at least one number
            $password .= $numbers[rand(0, strlen($numbers) - 1)];

            // Fill the rest with random characters (only letters and numbers)
            $characters = $uppercase . $lowercase . $numbers;
            for ($i = 3; $i < $length; $i++) {
                $password .= $characters[rand(0, strlen($characters) - 1)];
            }

            // Shuffle the password
            return str_shuffle($password);
        });
        $request_data = [
            'email' => $email,
            'firstName' => $firstname,
            'lastName' => $lastname,
            'password' => $password,
            'ip' => $ip,
            'phone' => $phone,
            'areaCode' => $country_code,
            'offerName' => $pageName,
        ];

        try {
            $response = Http::withHeaders([
                'Api-Key' => self::CLCKSON_API_KEY,
            ])->post(self::CLCKSON_URL, $request_data);

            $data = $response->json();
            \Log::info('Clckson API Response:', ['data' => $data]);

            // Success case - has redirect URL
            if (isset($data['details']['redirect']['url'])) {
                return response()->json([
                    'success' => true,
                    'data' => $data,
                    'url' => route('thank-you', [
                        'country' => $country,
                        'redirect_url' => urlencode($data['details']['redirect']['url']),
                    ])
                ], 200);
            }

            // Handle registration errors
            if (isset($data['code']) && $data['code'] === 30000) {
                if (!empty($data['errors'])) {
                    $this->setRetryFlag($request, 'clckson');
                    return $this->handleAnimeAPI($country, true, $request);
                }
            }

            // Rate limit error
            if (isset($data['message']) && str_contains($data['message'], 'attempts for registration')) {
                $this->setRetryFlag($request, 'clckson');
                return $this->handleAnimeAPI($country, true, $request);

            }

            // Location error
            if (isset($data['errors']) && !empty($data['errors'])) {
                $this->setRetryFlag($request, 'clckson');
                return $this->handleAnimeAPI($country, true, $request);
            }
            $this->setRetryFlag($request, 'clckson');
            return $this->handleAnimeAPI($country, true, $request);


        } catch (\Exception $e) {

            \Log::error('Clckson API Exception:', [
                'message' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);

            $this->setRetryFlag($request, 'clckson');
            return $this->handleAnimeAPI($country, true, $request);

            return response()->json([
                'success' => false,
                'message' => googleTrans('Service temporarily unavailable. Please try again later.', countryLang($country)),
                'data' => null
            ], 200);
        }
    }

    private function AllData(Request $request)
    {

        return [
            $request->input('first_name'),
            $request->input('last_name'),
            $request->input('email'),
            str_replace(' ', '', $request->input('phone')),
            $request->input('country_code'),
            $request->input('country_name'),
            $request->header('CF-Connecting-IP') ?? $request->header('X-Forwarded-For') ?? $request->ip(),
            strtoupper(substr($request->server('HTTP_ACCEPT_LANGUAGE', 'en'), 0, 2)),
            env('Website_title', 'test name'),
        ];
    }

    private function apiResponse($success, $message = null, $type = null, $url = null, $data = null, $status = 200)
    {
        return response()->json(compact('success', 'message', 'type', 'url', 'data'), $status);
    }

    private function setRetryFlag(Request $request, $api)
    {
        $request->merge(["retry_{$api}" => true]);
    }

    private function hasRetryFlag(Request $request, $api)
    {
        return $request->has("retry_{$api}");
    }
}
