<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('posts', function (Blueprint $table) {
            $table->id();

            // Basic post fields
            $table->string('title'); // Post title
            $table->json('slug')->nullable(); // For storing slugs in 'en' and 'ar'
            $table->longText('content'); // Post content
            $table->foreignId('user_id')->nullable()
                ->constrained('users')->nullOnDelete(); // Author ID

            // SEO fields
            $table->json('seo_title')->nullable(); // Custom SEO title
            $table->json('seo_description', 160)->nullable(); // Meta description
            $table->json('seo_keywords')->nullable(); // Meta keywords as JSON array
            $table->json('canonical_url')->nullable(); // Canonical URL

            // Open Graph fields for social sharing
            $table->json('og_title')->nullable(); // Open Graph title
            $table->json('og_description')->nullable(); // Open Graph description
            $table->string('og_image')->nullable(); // Open Graph image URL
            $table->string('og_type')->default('article'); // Open Graph type, e.g., article, website

            // Twitter Card fields
            $table->json('twitter_title')->nullable(); // Twitter title
            $table->json('twitter_description')->nullable(); // Twitter description
            $table->string('twitter_image')->nullable(); // Twitter image URL
            $table->string('twitter_card')->default('summary_large_image'); // Twitter card type

            // Additional settings
            $table->boolean('is_published')->default(false); // Publish status
            $table->timestamp('published_at')->nullable(); // Scheduled publish date
            $table->timestamps(); // Created and updated at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('posts', function (Blueprint $table) {
            $table->dropForeign(['category_id']); // Adjust to match your column name
        });

        Schema::dropIfExists('posts');
    }
};
