<script src='https://api.tomtom.com/maps-sdk-for-web/cdn/6.x/6.18.0/maps/maps-web.min.js'></script>

<script src="https://maps.googleapis.com/maps/api/js?key={{env('GOOGLE_MAP_KEY')}}&libraries=places&language={{App()->getLocale()}}&callback=initialize"
        async defer></script>

<script>
    function initialize() {
        $('form').on('keyup keypress', function (e) {
            let keyCode = e.keyCode || e.which;
            if (keyCode === 13) {
                e.preventDefault();
                return false;
            }
        });

        // Set up Google Map for pickup location
        const pickupInputs = document.querySelectorAll(".map-input");
        setupGoogleMap(pickupInputs, 'pickup');

        // Set up Google Map for return location
        const returnInputs = document.querySelectorAll(".map-input-return");
        setupGoogleMap(returnInputs, 'return');

        function setupGoogleMap(inputs, locationType) {
            // Default coordinates if not provided
            let DefaultLat = {{Cookie::get('lat') ?? '24.774265'}};
            let DefaultLng = {{Cookie::get('lng') ?? '46.738586'}};

            const autocompletes = [];
            const geocoder = new google.maps.Geocoder();

            for (let i = 0; i < inputs.length; i++) {
                const input = inputs[i];
                const fieldKey = input.id.replace(`-input-${locationType}`, '');
                console.log(`latitude-${fieldKey}-${locationType}`);
                const isEdit = document.getElementById(`latitude-${locationType}`).value !== ''
                    && document.getElementById(`longitude-${locationType}`).value !== '';

                // Get latitude and longitude values or use default if not available
                const latitude = parseFloat(document.getElementById(`latitude-${locationType}`).value) || DefaultLat;
                const longitude = parseFloat(document.getElementById(`longitude-${locationType}`).value) || DefaultLng;

                // Set unique IDs for map containers and maps
                const mapContainerId = `address-map-container-${locationType}`;
                const mapId = `address-map-${locationType}`;

                // Create a new map
                let map = new google.maps.Map(document.getElementById(mapId), {
                    center: {lat: latitude, lng: longitude},
                    zoom: 15
                });

                // Create a marker on the map
                let marker = new google.maps.Marker({
                    map: map,
                    position: {lat: latitude, lng: longitude},
                    draggable: true
                });

                marker.setVisible(true);

                // Set up Autocomplete for the input field
                const autocomplete = new google.maps.places.Autocomplete(input);
                autocomplete.key = fieldKey;
                autocompletes.push({input: input, map: map, marker: marker, autocomplete: autocomplete});
            }

            for (let i = 0; i < autocompletes.length; i++) {
                const input = autocompletes[i].input;
                const autocomplete = autocompletes[i].autocomplete;
                const map = autocompletes[i].map;
                const marker = autocompletes[i].marker;
                setupAutocompleteEvents(autocomplete, map, marker, locationType);
            }

            function setupAutocompleteEvents(autocomplete, map, marker, locationType) {
                google.maps.event.addListener(autocomplete, 'place_changed', function () {
                    marker.setVisible(true);
                    const place = autocomplete.getPlace();

                    geocoder.geocode({'placeId': place.place_id}, function (results, status) {
                        if (status === google.maps.GeocoderStatus.OK) {
                            const street_address = results[0].formatted_address;
                            const lat = results[0].geometry.location.lat();
                            const lng = results[0].geometry.location.lng();
                            setLocationCoordinates(autocomplete.key, lat, lng, street_address, locationType);
                        }
                    });

                    if (!place.geometry) {
                        window.alert("No details available for input: '" + place.name + "'");
                        input.value = "";
                        return;
                    }

                    if (place.geometry.viewport) {
                        map.fitBounds(place.geometry.viewport);
                    } else {
                        map.setCenter(place.geometry.location);
                        map.setZoom(17);
                    }
                    marker.setPosition(place.geometry.location);
                    marker.setVisible(true);
                });

                google.maps.event.addListener(marker, 'position_changed', function () {
                    var latpos = marker.getPosition().lat();
                    var lngpos = marker.getPosition().lng();
                    document.getElementById(`latitude-${locationType}`).value = latpos;
                    document.getElementById(`longitude-${locationType}`).value = lngpos;
                    geocodePosition(marker.getPosition(), locationType);
                });
            }


            function geocodePosition(pos, locationType) {
                geocoder.geocode({latLng: pos}, function (results, status) {
                    if (status == google.maps.GeocoderStatus.OK) {
                        updateMarkerAddress(results[0].formatted_address, locationType);
                    }
                });
            }

            function updateMarkerAddress(str, locationType) {
                document.getElementById(`location_address-${locationType}`).value = str;
            }

// Add this part to your existing code
            function setLocationCoordinates(key, lat, lng, street_address, locationType) {
                const latitudeField = document.getElementById(`latitude-${locationType}`);
                const longitudeField = document.getElementById(`longitude-${locationType}`);
                const place_name = document.getElementById(`location_address-${locationType}`);
                latitudeField.value = lat;
                longitudeField.value = lng;
                place_name.value = street_address;
            }
        }
    }
</script>