@extends('layouts.app')
@section('title', $website_title .' سياسة الخصوصية ')
@php( $meta_description = "اكتشف كيف يقوم ". $website_title." بحماية بياناتك الشخصية. توضح سياسة الخصوصية لدينا الإجراءات التي نتخذها لضمان أمان وشفافية معلوماتك.")

@section('content')
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>سياسة الخصوصية</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
                <b>آخر تحديث:</b> سبتمبر
            </p>
            <h3>{{ aiTrans('1. المقدمة', $locale) }}</h3>
            <p>
                {{ aiTrans('تصف هذه الإعلان سياسة الخصوصية المتبعة من قبل', $locale) }} {{ $website_title }} ("{{ aiTrans('نحن', $locale) }}،" "{{ aiTrans('خاصتنا', $locale) }}،" "{{ aiTrans('أو', $locale) }}")
                {{ aiTrans('بخصوص منتجاتنا وخدماتنا ("الخدمات") و', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('الموقع', $locale) }}</a>
                {{ aiTrans('("الموقع")', $locale) }}. {{ aiTrans('حماية خصوصيتك وسرية معلوماتك أمر بالغ الأهمية بالنسبة لنا أثناء تقديم خدماتنا وتشغيل الموقع.', $locale) }}
            </p>
            <p>
                {{ aiTrans('قد تحتوي خدماتنا والموقع على روابط لمواقع وخدمات تابعة لأطراف ثالثة. نحن لسنا مسؤولين عن ممارسات الخصوصية لهذه الكيانات الخارجية. ننصحك بمراجعة سياسات الخصوصية الخاصة بهم قبل استخدامها.', $locale) }}
            </p>
            <p>
                {{ aiTrans('جميع المعلومات التي نحصل عليها في إطار خدماتنا تُعامل على أنها سرية. نستخدم إجراءات فنية وأمنية وتنظيمية قوية لحماية البيانات الشخصية (كما تُعرّف أدناه) من المعالجة غير المصرح بها أو الفقدان العرضي أو التدمير أو الضرر أو السرقة أو الإفشاء.', $locale) }}
            </p>
            <p>
                {{ aiTrans('عند إرسال معلوماتك عبر موقعنا، قد يُطلب منك تقديم معلومات شخصية مثل اسمك وبريدك الإلكتروني ورقم الهاتف وتاريخ الميلاد ومختلف تفاصيل الهوية. قد تُستخدم هذه المعلومات لأغراض متنوعة بما في ذلك التحقق من الهوية وإدارة المعلومات وتقديم الدعم الفني والوفاء بالالتزامات التعاقدية والقانونية. قد ننقل تفاصيل مهمة عبر الإخطارات، وبموافقتك، نقدم معلومات حول المنتجات والخدمات عبر الرسائل القصيرة والبريد الإلكتروني وغيرها. لديك خيار إدارة تفضيلات الإشعارات وإلغاء الاشتراك في اتصالات معينة.', $locale) }}
            </p>
            <h3>{{ aiTrans('2. الموقع؛ الزائرون والمستخدمون', $locale) }}</h3>
            <h4>{{ aiTrans('2.1. عام', $locale) }}</h4>
            <p>
                {{ aiTrans('يحدد هذا القسم تفاصيل جمع البيانات من الفئات المختلفة: زوار الموقع ("الزائرين")، المستخدمين ("المستخدمين") والشركاء التجاريين (مجتمعين "الشركاء"). تشمل البيانات الشخصية عنوان IP والاسم وتفاصيل الاتصال ومعلومات حول العلاقة معنا، وفقًا للوائح حماية البيانات المعمول بها.', $locale) }}
            </p>
            <h4>{{ aiTrans('2.2. الجمع والاستخدام', $locale) }}</h4>
            <p>
                {{ aiTrans('بزيارة الموقع، أنت توافق على جمع واستخدام بياناتك الشخصية. عدم الموافقة على هذه الشروط يجب أن يمنعك من زيارة الموقع. قد نجمع المعلومات عبر نشاط تصفح الصفحات وعناوين IP وملفات تعريف الارتباط. بالإضافة لذلك، نعالج البيانات المقدمة طوعيًا في النماذج والسجلات.', $locale) }}
            </p>
            <h4>{{ aiTrans('2.3. الغرض من معالجة البيانات الشخصية', $locale) }}</h4>
            <p>
                {{ aiTrans('نعالج البيانات الشخصية لتحسين وفهم وتخصيص موقعنا وخدماتنا. يشمل ذلك تحسين الدقة والاتصال حول الخدمات والدعم والالتزامات التعاقدية والتعاون مع الشركاء. الموافقة أو الأساس القانوني ضروري لأي معالجة.', $locale) }}
            </p>
            <p>{{ aiTrans('يصف ما يلي الأغراض والأساس القانوني لمعالجة البيانات الشخصية:', $locale) }}</p>
<table>
    <tbody>
    <tr>
        <td>{{ aiTrans('تسجيل كصاحب حساب', $locale) }}</td>
        <td>{{ aiTrans('موافقتك؛ تنفيذ الخدمات أو الالتزامات التعاقدية', $locale) }}</td>
    </tr>
    <tr>
        <td>{{ aiTrans('تقديم واستخدام الخدمات', $locale) }}</td>
        <td>{{ aiTrans('تنفيذ الخدمات أو الالتزامات التعاقدية', $locale) }}</td>
    </tr>
    <tr>
        <td>{{ aiTrans('التحديثات التشغيلية', $locale) }}</td>
        <td>{{ aiTrans('تنفيذ الخدمات أو الالتزامات التعاقدية', $locale) }}</td>
    </tr>
    <tr>
        <td>{{ aiTrans('الرد على الاستفسارات وتقديم الدعم', $locale) }}</td>
        <td>{{ aiTrans('المصالح المشروعة أو تنفيذ الخدمات', $locale) }}</td>
    </tr>
    <tr>
        <td>{{ aiTrans('خدمات وإعلانات وتسويق مخصصة', $locale) }}</td>
        <td>{{ aiTrans('المصالح المشروعة أو موافقتك', $locale) }}</td>
    </tr>
    <tr>
        <td>{{ aiTrans('تحسين وعرض خدمات جديدة', $locale) }}</td>
        <td>{{ aiTrans('الموافقة والمصالح المشروعة', $locale) }}</td>
    </tr>
    <tr>
        <td>{{ aiTrans('إرسال مواد إعلانية وتسويقية', $locale) }}</td>
        <td>{{ aiTrans('موافقتك', $locale) }}</td>
    </tr>
    <tr>
        <td>{{ aiTrans('تحليل فعالية الحملات التسويقية', $locale) }}</td>
        <td>{{ aiTrans('المصالح المشروعة أو الموافقة', $locale) }}</td>
    </tr>
    <tr>
        <td>{{ aiTrans('تنفيذ أنشطة دعم متنوعة', $locale) }}</td>
        <td>{{ aiTrans('المصالح المشروعة أو تنفيذ الخدمات', $locale) }}</td>
    </tr>
    <tr>
        <td>{{ aiTrans('تحليل، بما في ذلك التحليل الإحصائي', $locale) }}</td>
        <td>{{ aiTrans('المصالح المشروعة', $locale) }}</td>
    </tr>
    <tr>
        <td>{{ aiTrans('حماية المصالح والحقوق والممتلكات', $locale) }}</td>
        <td>{{ aiTrans('المصالح المشروعة أو الالتزامات القانونية', $locale) }}</td>
    </tr>
    </tbody>
</table>
            <h4>{{ aiTrans('2.4. مشاركة البيانات الشخصية', $locale) }}</h4>
            <p>
                {{ aiTrans('قد نشارك المعلومات مع مقدمي الخدمات والشركاء والمتعاقدين. بالنسبة للزائرين والمستخدمين في المنطقة الأوروبية، يتم معالجة البيانات وفقًا لـ GDPR وقوانين حماية البيانات المعمول بها.', $locale) }}
            </p>
            <h3>{{ aiTrans('3. الشركاء', $locale) }}</h3>
            <h4>{{ aiTrans('3.1. عام', $locale) }}</h4>
            <p>
                {{ aiTrans('لتقديم الخدمات والتعاون مع الشركاء، نجمع ونعالج أنواعًا محددة من البيانات. الشركاء مسؤولون عن بياناتهم، ويمكننا الوصول إليها عبر وسائل آمنة.', $locale) }}
            </p>
            <h4>{{ aiTrans('3.2. معالجة البيانات الشخصية', $locale) }}</h4>
            <p>
                {{ aiTrans('نعتمد على موافقة الشركاء أو المصالح المشروعة لمعالجة البيانات الشخصية. قد يتم إنشاء تجميعات بيانات لأغراض التطوير وتحسين الجودة.', $locale) }}
            </p>
            <h4>{{ aiTrans('3.3. التحكم/المعالج', $locale) }}</h4>
            <p>{{ aiTrans('قد نعمل كمسيطر أو معالج حسب نوع البيانات:', $locale) }}</p>
            <ul>
                <li>{{ aiTrans('بيانات الزائر/المستخدم: مسيطر', $locale) }}</li>
                <li>{{ aiTrans('بيانات الشريك: معالج', $locale) }}</li>
                <li>{{ aiTrans('جميع البيانات مستضافة بأمان وفقًا لأعلى معايير الأمان. ننفذ ضوابط مادية وفنية وتنظيمية.', $locale) }}</li>
            </ul>
            <h4>{{ aiTrans('3.4. حماية بيانات الأطراف الثالثة', $locale) }}</h4>
            <p>{{ aiTrans('إذا تضمنت الخدمات معالجة بيانات شخصية على منصة طرف ثالث:', $locale) }}</p>
            <ul>
                <li>{{ aiTrans('نعمل كمعالج', $locale) }}</li>
                <li>{{ aiTrans('الالتزام بتعليمات الطرف الثالث', $locale) }}</li>
                <li>{{ aiTrans('تنفيذ إجراءات أمنية', $locale) }}</li>
                <li>{{ aiTrans('الإبلاغ عن خروقات البيانات', $locale) }}</li>
                <li>{{ aiTrans('عدم التعاقد من الباطن دون موافقة', $locale) }}</li>
                <li>{{ aiTrans('عدم معالجة البيانات خارج المنطقة الاقتصادية الأوروبية دون موافقة', $locale) }}</li>
                <li>{{ aiTrans('للاتصالات التسويقية الإلكترونية، نضمن الموافقة وخيارات الإلغاء.', $locale) }}</li>
            </ul>
            <h3>{{ aiTrans('4. الأمان', $locale) }}</h3>
            <p>
                {{ aiTrans('نستخدم ضوابط إدارية وتنظيمية وفنية لحماية البيانات الشخصية من الوصول أو الكشف أو التعديل أو الفقدان أو الاستخدام غير المصرح به. عند مشاركة البيانات مع أطراف ثالثة، نضمن التزامهم بنفس معايير الحماية، مع وضع التزامات تعاقدية للمعالجة الحصرية الآمنة وفقًا لهذه السياسة.', $locale) }}
            </p>
            <p>
                {{ aiTrans('إذا كان هناك اعتقاد باختراق التفاعل معنا، يجب على الزائرين أو المستخدمين أو الشركاء إخطارنا فورًا. تجدر الإشارة إلى أن إجراءاتنا الأمنية لا تضمن الحماية الكاملة من هجمات الأطراف الثالثة. يقر المستخدمون بالمخاطر الكامنة والانتهاكات المحتملة.', $locale) }}
            </p>
            <h3>{{ aiTrans('5. ملفات تعريف الارتباط', $locale) }}</h3>
            <p>
                {{ aiTrans('راجع', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('سياسة ملفات تعريف الارتباط', $locale) }}</a> {{ aiTrans('لمعلومات مفصلة عن أنواع ملفات التعريف وتقنيات التتبع المستخدمة في الموقع، أسباب الاستخدام وكيفية القبول أو الرفض.', $locale) }}
            </p>
            <h3>{{ aiTrans('6. روابط لمواقع أخرى', $locale) }}</h3>
            <p>
                {{ aiTrans('أثناء التصفح، قد يصادف المستخدمون روابط لمواقع خارجية خارج سيطرتنا. نحن لسنا مسؤولين عن المحتوى أو سياسات الخصوصية لهذه المواقع. ينصح المستخدمون بمراجعة سياسات الخصوصية قبل مشاركة أي بيانات شخصية.', $locale) }}
            </p>
            <h3>{{ aiTrans('7. الاحتفاظ والحذف', $locale) }}</h3>
            <p>
                {{ aiTrans('لا يتم الاحتفاظ بالبيانات أكثر من الضرورة. المستخدمون ذوو الحسابات النشطة مسؤولون عن الحذف الفوري. بعد إنهاء الحساب أو الشراكة، يتم حذف البيانات الشخصية وفقًا للقوانين وسياساتنا الداخلية.', $locale) }}
            </p>
            <p>
                {{ aiTrans('سحب الموافقة على معالجة البيانات قد يحد من الوصول لبعض الخدمات، دون أحقية في مطالبات أو منازعات.', $locale) }}
            </p>
            <h3>{{ aiTrans('8. حقوقك', $locale) }}</h3>
            <p>{{ aiTrans('للمستخدمين حقوق محددة متعلقة ببياناتهم الشخصية:', $locale) }}</p>
            <h4>{{ aiTrans('8.1. حق الوصول', $locale) }}</h4>
            <ul>
                <li>{{ aiTrans('التأكيد على معالجة البيانات الشخصية', $locale) }}</li>
                <li>{{ aiTrans('الوصول للبيانات والمعلومات ذات الصلة', $locale) }}</li>
                <li>{{ aiTrans('معلومات عن أغراض المعالجة، الفئات، المستلمين، مدة التخزين، الحقوق ووجود ملفات تعريف', $locale) }}</li>
            </ul>
            <h4>{{ aiTrans('8.2. حق التصحيح', $locale) }}</h4>
            <ul>
                <li>{{ aiTrans('تصحيح بيانات غير دقيقة', $locale) }}</li>
                <li>{{ aiTrans('إكمال بيانات ناقصة', $locale) }}</li>
            </ul>
            <h4>{{ aiTrans('8.3. حق الحذف', $locale) }}</h4>
            <ul>
                <li>{{ aiTrans('طلب حذف البيانات في ظروف محددة', $locale) }}</li>
            </ul>
            <h4>{{ aiTrans('8.4. حق تقييد المعالجة', $locale) }}</h4>
            <ul>
                <li>{{ aiTrans('تقييد المعالجة في ظروف محددة', $locale) }}</li>
            </ul>
            <h4>{{ aiTrans('8.5. حق نقل البيانات', $locale) }}</h4>
            <ul>
                <li>{{ aiTrans('استلام البيانات بصيغة منظمة وقابلة للقراءة الآلية', $locale) }}</li>
                <li>{{ aiTrans('نقل البيانات لمسيطر آخر', $locale) }}</li>
            </ul>
            <h4>{{ aiTrans('8.6. حق الاعتراض', $locale) }}</h4>
            <ul>
                <li>{{ aiTrans('الاعتراض على المعالجة بناءً على مصالح مشروعة أو تسويق مباشر', $locale) }}</li>
                <li>{{ aiTrans('إيقاف المعالجة إلا لأسباب قاهرة/قانونية', $locale) }}</li>
            </ul>
            <h4>{{ aiTrans('8.7. حق سحب الموافقة', $locale) }}</h4>
            <ul>
                <li>{{ aiTrans('سحب الموافقة على معالجة البيانات في أي وقت', $locale) }}</li>
            </ul>
            <h3>{{ aiTrans('9. المواد الإعلانية والتسويقية', $locale) }}</h3>
            <p>
                {{ aiTrans('يتم الحصول على الموافقة لاستخدام البيانات الشخصية وتفاصيل الاتصال لتقديم مواد إعلانية. يمكن سحب الموافقة عبر إرسال إشعار كتابي للبريد الإلكتروني المحدد.', $locale) }}
            </p>
            <h3>{{ aiTrans('10. قبول هذه السياسة', $locale) }}</h3>
            <p>
                {{ aiTrans('باستخدام الموقع/الخدمات، يُفترض موافقة الزائرين والمستخدمين والشركاء على هذه السياسة. أي اعتراض يعني الامتناع عن الاستخدام. نحتفظ بحق تعديل السياسة مع تشجيع المستخدمين على مراجعة التحديثات. الاستمرار في الاستخدام بعد التعديلات يدل على القبول.', $locale) }}
            </p>
            <h3>{{ aiTrans('11. الالتزام القانوني بكشف البيانات', $locale) }}</h3>
            <p>
                {{ aiTrans('قد يتم الكشف عن البيانات دون إذن مسبق إذا اعتُقد ضرورة إثبات الهوية أو الاتصال أو إجراءات قانونية ضد أشخاص انتهكوا الحقوق. يتم الكشف عندما يقتضي القانون.', $locale) }}
            </p>
            <h3>{{ aiTrans('12. مسؤول حماية البيانات', $locale) }}</h3>
            <p>
                {{ aiTrans('للاستفسارات المتعلقة بالخصوصية، يمكن الاتصال بـ "مسؤول حماية البيانات" المعين عبر البريد:', $locale) }}
                <span >info{{ '@'.$website_title }}</span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>
        </div>
    </div>
</div>
@endsection
