@extends('layouts.app')
@section('title', $website_title .' | Όροι και Προϋποθέσεις')
@php( $meta_description = "Διαβάστε τους όρους και τις προϋποθέσεις του ". $website_title.". Οι όροι μας εξηγούν τα δικαιώματα, τις υποχρεώσεις σας και πώς να χρησιμοποιείτε τις υπηρεσίες μας με ασφάλεια και αποτελεσματικότητα.")


@section('content')
<div class="terms-and-conditions wf-section">
        <div class="w-container">
            <h1>ΟΡΟΙ ΚΑΙ ΠΡΟΫΠΟΘΕΣΕΙΣ</h1>
            <div>
                <style>
                    table {
                        width: 100%;
                    }
    
                    table,
                    th,
                    td {
                        border: 1px solid;
                        border-collapse: collapse;
                    }
    
                    th,
                    td {
                        padding: 10px;
                    }
    
                    table td {
                        vertical-align: top;
                    }
    
                    .nested-list {
                        counter-reset: item;
                    }
    
                    .nested-list li {
                        display: block;
                    }
    
                    .nested-list li:before {
                        content: counters(item, '.') '. ';
                        counter-increment: item;
                    }
    
                    .legal-section {
                        text-align: left;
                    }
    
                    .legal-section h3 {
                        margin-top: 30px;
                        font-size: 24px;
                    }
    
                    .legal-section h4 {
                        font-size: 18px;
                    }
                </style>
                <p>
                    {{aiTrans('Ευχαριστούμε που επισκεφθήκατε τον')}} <a href="{{ route('home', $country) }}"> ιστότοπό μας</a> {{aiTrans('(ο “Ιστότοπος”) όπου βρήκατε τον σύνδεσμο προς αυτούς τους Όρους και Προϋποθέσεις (ο “Ιστότοπος”), καθώς και την')}} <a href="{{ route('privacy', $country) }}">{{aiTrans('Πολιτική Απορρήτου')}}</a> {{aiTrans('(η "Πολιτική Απορρήτου"). Αυτός ο ιστότοπος διαχειρίζεται και ελέγχεται από την')}} {{ $website_title }}{{aiTrans(' και οποιεσδήποτε μητρικές, θυγατρικές ή σχετικές οντότητες, όλες αναφερόμενες ως')}} {{ $website_title }}. {{aiTrans('Ο Ιστότοπος είναι ιδιοκτησία μας
                    (αναφερόμενοι συλλογικά ως “εμείς”, “μας” ή “εμάς”) και μπορείτε να επικοινωνήσετε μαζί μας οποιαδήποτε στιγμή μέσω email')}}
                    στο: <span >info{{ '@'.$website_title }}</span>
                </p>
                <p>
                    {{ aiTrans('Με την πρόσβαση στον Ιστότοπο ή τη χρήση των προϊόντων και/ή των υπηρεσιών μας ("Υπηρεσίες του Παρόχου" και συλλογικά με τις Υπηρεσίες Συνδρομής, αναφερόμενες ως "Υπηρεσίες"), συμφωνείτε να συμμορφώνεστε με αυτούς τους Όρους Χρήσης ("Όροι") και την Πολιτική Απορρήτου μας. Αυτοί οι Όροι περιλαμβάνουν λειτουργικούς κανόνες, πολιτικές, πληροφορίες και άλλους συμπληρωματικούς όρους. Διατηρούμε το δικαίωμα να τροποποιούμε αυτούς τους Όρους κατά καιρούς χωρίς προειδοποίηση και κατά τη διακριτική μας ευχέρεια. Είναι δική σας ευθύνη να ελέγχετε περιοδικά αυτήν τη σελίδα για ενημερώσεις στους Όρους, οι οποίοι θα τίθενται σε ισχύ μετά τη δημοσίευσή τους. Η συνεχιζόμενη χρήση του Ιστότοπου θα θεωρείται αποδοχή των Όρων.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Παρακαλούμε εξετάστε προσεκτικά τους πλήρεις όρους αυτών των Όρων και Προϋποθέσεων. Εάν διαφωνείτε με οποιοδήποτε μέρος αυτών, δεν σας επιτρέπεται η χρήση των Υπηρεσιών ή του Ιστότοπου με οποιονδήποτε τρόπο. Διατηρούμε το δικαίωμα να αρνηθούμε την πρόσβαση στις Υπηρεσίες και/ή στον Ιστότοπο κατά τη διακριτική μας ευχέρεια.', $locale) }}
                </p>
                <h3>{{ aiTrans('ΧΩΡΙΣ ΕΠΕΝΔΥΤΙΚΗ ΣΥΜΒΟΥΛΗ', $locale) }}</h3>
                <p>
                    {{ aiTrans('Εκτός εάν δηλώνεται ρητά διαφορετικά, αυτός ο ιστότοπος δεν έχει σχεδιαστεί για την παροχή προσωπικών οικονομικών ή επενδυτικών συμβουλών. Οι παρεχόμενες πληροφορίες δεν λαμβάνουν υπόψη τους ειδικούς επενδυτικούς σας στόχους, την οικονομική σας κατάσταση ή τις επενδυτικές σας ανάγκες.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Θα πρέπει να αξιολογήσετε αν οι πληροφορίες σε αυτόν τον ιστότοπο είναι κατάλληλες για τους επενδυτικούς σας στόχους, την οικονομική σας κατάσταση και τις επενδυτικές σας ανάγκες. Αυτό θα πρέπει να το κάνετε πριν λάβετε οποιαδήποτε επενδυτική απόφαση βασισμένη στις πληροφορίες που παρέχονται σε αυτόν τον ιστότοπο. Μπορείτε να κάνετε αυτήν την αξιολόγηση μόνοι σας ή να ζητήσετε τη βοήθεια ενός ανεξάρτητου χρηματοοικονομικού συμβούλου.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Εκτός εάν δηλώνεται ρητά διαφορετικά, οι πληροφορίες που περιέχονται σε αυτόν τον ιστότοπο δεν συνιστούν σύσταση για επένδυση σε οποιοδήποτε χρηματοοικονομικό προϊόν ή υπηρεσία που προσφέρεται από οποιοδήποτε μέλος του ομίλου εταιρειών IG.', $locale) }}
                </p>
                <h3>{{ aiTrans('ΠΡΟΪΟΝΤΑ ΚΑΙ ΥΠΗΡΕΣΙΕΣ', $locale) }}</h3>
                <p>
                    {{ aiTrans('Δεν παρέχονται απαραίτητα όλα τα προϊόντα και οι υπηρεσίες που αναφέρονται σε αυτόν τον ιστότοπο από εμάς. Η αναφορά ή η χρήση οποιωνδήποτε προϊόντων, υπηρεσιών, ιστοτόπων ή δικτύων τρίτων δεν αποτελεί σύσταση αυτών των προϊόντων, υπηρεσιών, ιστοτόπων ή δικτύων. Αυτός ο ιστότοπος μπορεί να σας επιτρέψει να αποκτήσετε πρόσβαση σε ιστοτόπους και δίκτυα που παρέχονται από τρίτους μέσω υπερσυνδέσμου ή άλλου συνδέσμου.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Δεν αποδεχόμαστε καμία ευθύνη ή υποχρέωση οποιουδήποτε είδους σχετικά με οποιοδήποτε υλικό σε οποιονδήποτε ιστότοπο ή δίκτυο που δεν βρίσκεται υπό τον άμεσο έλεγχό μας. Αναγνωρίζετε ότι η πρόσβασή σας σε αυτούς τους άλλους ιστοτόπους ή δίκτυα μέσω αυτού του συνδέσμου μπορεί να μας υποχρεώσει να παρέχουμε ορισμένες πληροφορίες σχετικά με εσάς στον ιδιοκτήτη αυτού του ιστοτόπου ή δικτύου. Τίποτα σε αυτόν τον ιστότοπο δεν προορίζεται να αποτελεί, ούτε θα πρέπει να εκλαμβάνεται ως, επενδυτική ή οικονομική συμβουλή από εμάς.', $locale) }}
                </p>
                <h3>{{ aiTrans('ΠΕΔΙΟ ΕΦΑΡΜΟΓΗΣ ΚΑΙ ΤΡΟΠΟΠΟΙΗΣΗ', $locale) }}</h3>
                <p>
                    {{ aiTrans('Συμφωνείτε με τους όρους που περιγράφονται στο παρόν σχετικά με τη χρήση του Ιστότοπού μας. Αυτοί οι Όροι συνιστούν τη συνολική συμφωνία μεταξύ εσάς και εμάς, αντικαθιστώντας όλες τις προηγούμενες συμφωνίες, δηλώσεις, εγγυήσεις και κατανόηση σχετικά με τον Ιστότοπο.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Λάβετε υπόψη ότι αυτοί οι Όροι ενδέχεται να τροποποιούνται περιοδικά. Εάν τροποποιήσουμε αυτούς τους Όρους, θα σας ενημερώσουμε σχετικά με τις διαθέσιμες επιλογές λόγω αυτών των αλλαγών. Επιπλέον, θα δημοσιεύσουμε μια ειδοποίηση που θα υποδεικνύει την τροποποίηση. Η συνεχής χρήση του Ιστότοπου και/ή των Υπηρεσιών μας συνεπάγεται την πλήρη αποδοχή και συμμόρφωση με τους επικαιροποιημένους όρους και προϋποθέσεις. Είναι δική σας ευθύνη να ελέγχετε τακτικά αυτήν τη σελίδα για ενημερώσεις και/ή αλλαγές.', $locale) }}
                </p>
                <h3>{{ aiTrans('ΑΠΑΙΤΗΣΕΙΣ', $locale) }}</h3>
                <p>
                    {{ aiTrans('Ο Ιστότοπος και οι Υπηρεσίες μας διατίθενται αποκλειστικά σε άτομα που είναι νομικά επιλέξιμα για τη σύναψη δεσμευτικών συμβάσεων σύμφωνα με την ισχύουσα νομοθεσία. Δεν προορίζονται για χρήση από άτομα κάτω των δεκαοκτώ (18) ετών. Εάν είστε κάτω των δεκαοκτώ (18) ετών, δεν σας επιτρέπεται να χρησιμοποιείτε και/ή να έχετε πρόσβαση στον Ιστότοπο και/ή τις Υπηρεσίες.', $locale) }}
                </p>
                <h3>{{ aiTrans('ΠΕΡΙΓΡΑΦΗ ΤΩΝ ΥΠΗΡΕΣΙΩΝ', $locale) }}</h3>
                <p>
                    <i>{{ aiTrans('Υπηρεσίες Συνδρομής:', $locale) }}</i> {{ aiTrans('Με την εγγραφή σας στον Ιστότοπο και την έγκρισή σας από εμάς, μπορείτε να αποκτήσετε ή να προσπαθήσετε να αποκτήσετε Υπηρεσίες Συνδρομής έναντι αμοιβής ή δωρεάν. Αυτές οι υπηρεσίες παρέχουν περιεχόμενο μέσω email, κειμένου και άλλου υλικού ("Περιεχόμενο Συνδρομής") που σχετίζεται με το διαδικτυακό μάρκετινγκ από εμάς και συνεργαζόμενους τρίτους προμηθευτές ("Προμηθευτές Τρίτων"). Αυτό δεν αποτελεί επενδυτική συμβουλή. Κατανοείτε και συμφωνείτε ότι δεν είμαστε υπεύθυνοι ή υπόλογοι για την ακρίβεια, πληρότητα ή καταλληλότητα του Περιεχομένου Συνδρομής.', $locale) }}
                </p>
                <p>
                    <i>{{ aiTrans('Υπηρεσίες Προμηθευτών και Τρίτων:', $locale) }}</i> {{ aiTrans('Συμπληρώνοντας φόρμες εγγραφής, μπορείτε να αποκτήσετε ή να προσπαθήσετε να αποκτήσετε ορισμένα προϊόντα και/ή υπηρεσίες από τον Ιστότοπο. Οι περιγραφές προϊόντων και/ή υπηρεσιών στον Ιστότοπο ενδέχεται να παρέχονται από Προμηθευτές Τρίτων. Δεν εγγυόμαστε την ακρίβεια ή την πληρότητα αυτών των περιγραφών. Κατανοείτε και συμφωνείτε ότι δεν είμαστε υπεύθυνοι ή υπόλογοι για την αδυναμία σας να αποκτήσετε προϊόντα και/ή υπηρεσίες από τον Ιστότοπο ή τους συνεργάτες του, ούτε για οποιεσδήποτε διαφορές με πωλητές προϊόντων, διανομείς ή τρίτους προμηθευτές με τους οποίους μπορεί να αλληλεπιδράσετε.', $locale) }}
                </p>
                <h3>{{ aiTrans('ΠΡΟΣΤΑΣΙΑ ΔΕΔΟΜΕΝΩΝ', $locale) }}</h3>
                <p>
                    {{ aiTrans('Δεσμευόμαστε να προστατεύουμε τα προσωπικά σας δεδομένα σύμφωνα με τις πολιτικές απορρήτου μας. Μπορείτε να διαβάσετε περισσότερες λεπτομέρειες σχετικά με τη διαχείριση των δεδομένων σας στην', $locale) }}
                    <a href="{{ route('privacy', $country) }}">{{ aiTrans('Πολιτική Απορρήτου', $locale) }}</a>.
                </p>
                <h3>{{ aiTrans('ΕΠΙΛΟΓΗ ΝΟΜΟΘΕΣΙΑΣ ΚΑΙ ΔΙΚΑΙΟΔΟΣΙΑΣ', $locale) }}</h3>
                <p>
                    {{ aiTrans('Αυτοί οι Όροι διέπονται και ερμηνεύονται σύμφωνα με τη νομοθεσία του Ηνωμένου Βασιλείου. Τα Μέρη θα προσπαθήσουν να επιλύσουν οποιαδήποτε διαφορά προκύψει από αυτούς τους Όρους μέσω φιλικής διαπραγμάτευσης. Εάν τα Μέρη δεν καταλήξουν σε συμφωνία, η διαφορά θα επιλυθεί μέσω εμπιστευτικής διαιτησίας στο Λονδίνο, σύμφωνα με τους κανόνες της ICC. Κανένα μέρος δεν θα υποβάλει καταγγελία σε τοπικό δικαστήριο στη χώρα διαμονής του ή σε οποιοδήποτε άλλο δικαστήριο.', $locale) }}
                </p>
                <h3>{{ aiTrans('ΠΑΡΑΡΤΗΜΑ ΠΡΟΣΤΑΣΙΑΣ ΔΕΔΟΜΕΝΩΝ', $locale) }}</h3>
                <p>
                    {{ aiTrans('Αυτό το Παράρτημα Προστασίας Δεδομένων αποτελεί μέρος των Όρων και Προϋποθέσεών μας. Οι όροι που χρησιμοποιούνται εδώ έχουν τα καθορισμένα νοήματα σε αυτό το Παράρτημα. Εκτός εάν τροποποιηθεί παρακάτω, οι Όροι παραμένουν σε πλήρη ισχύ.', $locale) }}
                </p>
                <ol class="nested-list">
                    <li>
                        <b>{{ aiTrans('Ορισμοί', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                <b>{{ aiTrans('Εφαρμοστέοι Νόμοι:', $locale) }}</b> {{ aiTrans('Νόμοι της ΕΕ ή Κράτους Μέλους σχετικά με τα Προσωπικά Δεδομένα που υπόκεινται στους Νόμους Προστασίας Δεδομένων της ΕΕ και άλλους ισχύοντες νόμους για τα Προσωπικά Δεδομένα.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('Υπεύθυνος Επεξεργασίας:', $locale) }}</b> {{ aiTrans('Οντότητα που καθορίζει τους σκοπούς και τα μέσα επεξεργασίας των Προσωπικών Δεδομένων.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('Νόμοι Προστασίας Δεδομένων:', $locale) }}</b> {{ aiTrans('Νόμοι Προστασίας Δεδομένων της ΕΕ και νόμοι προστασίας δεδομένων ή απορρήτου οποιασδήποτε άλλης χώρας.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('Νόμοι Προστασίας Δεδομένων της ΕΕ:', $locale) }}</b> {{ aiTrans('Οδηγία 95/46/ΕΚ της ΕΕ, GDPR και σχετικοί νόμοι.', $locale) }}
                            </li>
                            <li>
                                <b>{{ aiTrans('GDPR:', $locale) }}</b> {{ aiTrans('Γενικός Κανονισμός Προστασίας Δεδομένων της ΕΕ 2016/679.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Συλλογή και Επεξεργασία Προσωπικών Δεδομένων', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Συμφωνούμε να συμμορφωνόμαστε με όλους τους ισχύοντες Νόμους Προστασίας Δεδομένων κατά την Επεξεργασία Προσωπικών Δεδομένων.', $locale) }}
                                <ol class="nested-list">
                                    <li>
                                        {{ aiTrans('Δηλώνουμε και εγγυόμαστε ότι έχουμε τις απαραίτητες άδειες και συγκαταθέσεις από τους υποκειμένους των δεδομένων για τη νόμιμη συλλογή, επεξεργασία και κοινοποίηση Προσωπικών Δεδομένων μέσω των Υπηρεσιών σύμφωνα με τους Ισχύοντες Νόμους.', $locale) }}
                                    </li>
                                    <li>
                                        {{ aiTrans('Θα διατηρούμε έναν μηχανισμό για την απόκτηση και ανάκληση συγκατάθεσης, σύμφωνα με τους Ισχύοντες Νόμους, καθώς και μια δημόσια διαθέσιμη πολιτική απορρήτου.', $locale) }}
                                    </li>
                                    <li>
                                        {{ aiTrans('Αναγνωρίζουμε ότι δεν παρέχουμε Υπηρεσίες σε παιδιά κάτω των δεκαοκτώ (18) ετών.', $locale) }}
                                    </li>
                                </ol>
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Ασφάλεια', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Θα εφαρμόσουμε κατάλληλα τεχνικά και οργανωτικά μέτρα ασφαλείας σύμφωνα με το Άρθρο 32(1) του GDPR.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Υπεργολάβοι Επεξεργασίας', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Μας εξουσιοδοτείτε να ορίζουμε Υπεργολάβους Επεξεργασίας και να διασφαλίζουμε ότι οι γραπτές συμφωνίες τους παρέχουν το ίδιο επίπεδο προστασίας των Προσωπικών Δεδομένων όπως περιγράφεται σε αυτό το Παράρτημα και πληρούν τις απαιτήσεις του GDPR.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Δικαιώματα Υποκειμένων Δεδομένων', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Θα βοηθούμε στην απάντηση σε αιτήματα δικαιωμάτων Υποκειμένων Δεδομένων σύμφωνα με τους Νόμους Προστασίας Δεδομένων, λαμβάνοντας υπόψη τη φύση της Επεξεργασίας.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Παραβίαση Δεδομένων Προσωπικού Χαρακτήρα', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Θα ειδοποιούμε αμέσως τα επηρεαζόμενα Υποκείμενα Δεδομένων μόλις λάβουμε γνώση μιας Παραβίασης Δεδομένων Προσωπικού Χαρακτήρα, παρέχοντας βοήθεια στην έρευνα, τον μετριασμό και την αποκατάσταση.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Γενικοί Όροι', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Διαφορές ή αξιώσεις που απορρέουν από αυτούς τους Όρους υπόκεινται στη δικαιοδοσία που ορίζεται εδώ. Εάν κάποια διάταξη είναι άκυρη, το υπόλοιπο θα παραμείνει σε ισχύ.', $locale) }}
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b>{{ aiTrans('Τροποποιήσεις', $locale) }}</b>
                        <ol class="nested-list">
                            <li>
                                {{ aiTrans('Οι τροποποιήσεις αυτών των Όρων μπορούν να γίνουν κατά την απόλυτη διακριτική μας ευχέρεια ανά πάσα στιγμή.', $locale) }}
                            </li>
                        </ol>
                    </li>
                </ol>
                <p>
                    {{aiTrans('Με την αποδοχή αυτών των Όρων και Προϋποθέσεων, αναγνωρίζετε ότι έχετε διαβάσει, κατανοήσει και συμφωνείτε να δεσμεύεστε από όλους τους όρους που περιγράφονται παραπάνω. Η συνεχής χρήση του Ιστότοπου και των Υπηρεσιών συνιστά αποδοχή αυτών των όρων. Εάν έχετε οποιαδήποτε ερώτηση ή ανησυχία, επικοινωνήστε μαζί μας στο')}} <span >info{{ '@'.$website_title }}</span>
                </p>
                <script>
                    const emails = document.getElementsByClassName('email');
                    for (const email of emails) {
                        email.innerText = `info@${location.hostname}`;
                    }
                </script>

            </div>
        </div>
    </div>
@endsection
