@extends('layouts.app')
@section('title', $website_title .' | ABOUT US')
@php( $meta_description = "Discover how ". $website_title." helps you develop your cryptocurrency investment skills. We offer advanced tools and complete support to achieve your trading goals.")

@section('content')
<div class="what-is w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/what-is-img.webp"  sizes="(max-width: 991px) 100vw, (max-width: 2870px) 50vw, 1435px" alt="{{$website_title}}  - What exactly is online trading?" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h1 class="about-title">{{aiTrans('About Us')}}</h1>
        <h2 class="about-subtitle">{{aiTrans('What exactly is online trading?')}}</h2>
        <p>{{aiTrans('Online trading began in 1971 when the first trading software, the National Association of Securities Dealers Automated Quotations (NASDAQ), was launched as the first online trading software. Today, online trading is the most popular method of buying and selling various financial assets, such as Forex, cryptocurrencies, stocks, commodities, and even contracts for differences (CFDs).')}}</p>
        <p>
            
            {{ aiTrans(
                "Based on this, [website_title] was born.",
                $locale,
                ['website_title' => $website_title],
            ) }}</p>
        <p>{{aiTrans('The powerful and intuitive trading software can take advantage of small price differences in digital currencies across different exchanges. It then buys cryptocurrencies at a low price and sells them at a higher price. The final result is small amounts of profit that accumulate into significant earnings for the user.')}}</p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',)}}#formTop" class="button w-button">{{aiTrans('Watch the video')}}</a>
        </div>
    </div>
    <div class="what-is-bg-1"></div>
</div>

<div class="how-it-working wf-section">
    <div class="container w-container">
        <div class="how-it-working-text">
            
            {{ aiTrans(
                "Cryptocurrencies are highly volatile assets, and it is important to make good decisions when trading them. That is what [website_title] is all about. The powerful application ensures that cryptocurrency investors can access fast and relevant information while trading their favorite coins and tokens in the market. This way, they can track the best opportunities in the cryptocurrency markets and make precise and informed trading decisions at all times. [website_title] essentially ensures that no crypto investor trades blindly. The app allows you to trade with confidence and make the most of your trading activity.",
                $locale,
                ['website_title' => $website_title],
            ) }}</div>
    </div>
</div>

<div class="our-team w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/our-team-img.webp"  sizes="(max-width: 991px) 100vw, 50vw" alt="{{$website_title}}  - {{$website_title}} Team" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-team-title">
            {{ aiTrans(
                "[website_title] Team",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "The [website_title] team consists of dedicated trading professionals who aim to provide ordinary people, just like you, with the opportunity to trade Bitcoin and other cryptocurrencies effectively and profitably. The team has combined their knowledge and expertise to create a trading software solution capable of scanning different cryptocurrency exchanges quickly and efficiently to identify profitable trading opportunities. The entire process has been automated, allowing anyone to trade and earn their share of this lucrative market.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "[website_title] offers many benefits and advantages, and we are always committed to contributing positively to your trading experience and financial journey.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',)}}#formTop" class="button w-button">{{aiTrans('Register now')}}</a>
        </div>
    </div>
</div>
<div class="our-advantage w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/advantage-img.webp"  alt="{{$website_title}}  - Take advantage of the cryptocurrency markets and earn with {{$website_title}}" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-advantage-title">
            {{ aiTrans(
                "Take advantage of the cryptocurrency markets and earn with [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "At [website_title], we want to help you achieve financial freedom, and as the cryptocurrency market grows and evolves, there is no doubt that more trading opportunities will arise. This simply means more profits for you.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "Take control of your future today and sign up with [website_title]. Your success will change your life. Sign up now for your free account and start trading today!",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
    </div>
</div>
@endsection
