@extends('layouts.app')
@section('title', $website_title .' | Política de Privacidade')
@php( $meta_description = "Saiba como ". $website_title." protege suas informações pessoais. Nossa política de privacidade explica as medidas adotadas para garantir a segurança e a transparência dos seus dados.")

@section('content')
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>POLÍTICA DE PRIVACIDADE</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3>{{ aiTrans('1. Introdução', $locale) }}</h3>
            <p>
                {{ aiTrans('Esta política de privacidade descreve como', $locale) }} {{ $website_title }} ("{{ aiTrans('nós', $locale) }}", "{{ aiTrans('nosso', $locale) }}", "{{ aiTrans('ou', $locale) }}")
                {{ aiTrans('trata as informações pessoais em relação aos nossos produtos e serviços (os "Serviços") e ao', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('site', $locale) }}</a>
                {{ aiTrans('("Site")". A proteção da sua privacidade e a confidencialidade das suas informações são essenciais para nós ao oferecer nossos Serviços e operar o Site.', $locale) }}
            </p>
            <p>
                {{ aiTrans('Nossos Serviços e o Site podem conter links para sites e serviços de terceiros. Não nos responsabilizamos pelas práticas de privacidade dessas entidades externas. Recomendamos que você leia as políticas de privacidade desses serviços antes de utilizá-los.', $locale) }}
            </p>
            <p>
                {{ aiTrans('Todas as informações que recebemos em conexão com nossos Serviços são tratadas como confidenciais. Empregamos medidas de segurança técnicas, organizacionais e de proteção robustas para proteger seus Dados Pessoais (como definido abaixo) contra acessos não autorizados, perda acidental, destruição, danos, roubo ou divulgação.', $locale) }}
            </p>
            <p>
                {{ aiTrans('Ao fornecer informações através de nosso site, você pode ser solicitado a fornecer dados pessoais como seu nome, e-mail, telefone, data de nascimento e outros detalhes de identificação. Essas informações podem ser usadas, entre outras coisas, para verificar sua identidade, administrar informações, oferecer suporte técnico e cumprir com obrigações legais e contratuais. Podemos enviar comunicações importantes por notificações, e, com seu consentimento, também fornecer informações sobre produtos e serviços via SMS, e-mail, entre outros. Você poderá gerenciar suas preferências de notificação e cancelar a inscrição de algumas comunicações.', $locale) }}
            </p>
            <h3>{{ aiTrans('2. Site; Visitantes e Usuários', $locale) }}</h3>
            <h4>{{ aiTrans('2.1. Geral', $locale) }}</h4>
<p>
    {{ aiTrans('Esta seção descreve as particularidades da coleta de dados de diferentes grupos: visitantes do site ("Visitantes"), usuários ("Usuários") e parceiros comerciais (coletivamente "Parceiros"). Dados Pessoais incluem informações como endereço IP, nome, dados de contato e detalhes sobre o relacionamento conosco, conforme as regulamentações de proteção de dados aplicáveis.', $locale) }}
</p>
<h4>{{ aiTrans('2.2. Coleta e Uso', $locale) }}</h4>
<p>
    {{ aiTrans('Ao acessar o Site, você concorda com a coleta e o uso dos seus Dados Pessoais. Caso não concorde com esses termos, você não deverá acessar o Site. Podemos coletar informações através da visualização de páginas, endereços IP e cookies. Além disso, processamos dados fornecidos voluntariamente através de formulários e registros.', $locale) }}
</p>
<h4>{{ aiTrans('2.3. Finalidade do Processamento de Dados Pessoais', $locale) }}</h4>
<p>
    {{ aiTrans('Processamos Dados Pessoais para aprimorar, entender e personalizar nosso Site e Serviços. Isso envolve melhorar a precisão, comunicação sobre os Serviços, suporte, cumprimento de obrigações contratuais e colaboração com nossos parceiros. O consentimento ou a base legal são necessários para qualquer processamento.', $locale) }}
</p>
<p>{{ aiTrans('Abaixo estão as finalidades e a base legal para o processamento de Dados Pessoais:', $locale) }}</p>
<table>
    <tbody>
        <tr>
            <td>{{ aiTrans('Registro como titular de conta', $locale) }}</td>
            <td>{{ aiTrans('Seu consentimento; Execução de Serviços ou obrigações contratuais', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Fornecimento e uso de Serviços', $locale) }}</td>
            <td>{{ aiTrans('Execução de Serviços ou obrigações contratuais', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Atualizações operacionais', $locale) }}</td>
            <td>{{ aiTrans('Execução de Serviços ou obrigações contratuais', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Responder a consultas e fornecer suporte', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos ou execução de Serviços', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Serviços, publicidade e marketing sob medida', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos ou seu consentimento', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Melhoria e oferta de novos Serviços', $locale) }}</td>
            <td>{{ aiTrans('Consentimento e interesses legítimos', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Envio de materiais publicitários e de marketing', $locale) }}</td>
            <td>{{ aiTrans('Seu consentimento', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Análise da eficácia de campanhas de marketing', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos ou consentimento', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Execução de várias atividades de suporte', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos ou execução de Serviços', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Análise, incluindo análise estatística', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Proteção de interesses, direitos e bens', $locale) }}</td>
            <td>{{ aiTrans('Interesses legítimos ou obrigações legais', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h4>{{ aiTrans('2.4. Compartilhamento de Dados Pessoais', $locale) }}</h4>
<p>
    {{ aiTrans('Podemos compartilhar informações com nossos fornecedores de serviços, parceiros e contratados. Para Visitantes e Usuários localizados na Região de Dados Europeia, o processamento de dados é realizado de acordo com o GDPR e outras Leis de Proteção de Dados pertinentes.', $locale) }}
</p>
<h3>{{ aiTrans('3. Parceiros', $locale) }}</h3>
<h4>{{ aiTrans('3.1. Geral', $locale) }}</h4>
<p>
    {{ aiTrans('Para fornecer nossos Serviços e colaborar com Parceiros, coletamos e processamos certos tipos de dados. Os Parceiros são responsáveis pelos dados que compartilham, e nós podemos acessá-los de maneira segura.', $locale) }}
</p>
<h4>{{ aiTrans('3.2. Processamento de Dados Pessoais', $locale) }}</h4>
<p>
    {{ aiTrans('Processamos os Dados Pessoais com base no consentimento dos Parceiros ou em nossos interesses legítimos. Podemos criar agregações de dados com o objetivo de desenvolver e melhorar a qualidade de nossos serviços.', $locale) }}
</p>
<h4>{{ aiTrans('3.3. Controlador/Processador', $locale) }}</h4>
<p>{{ aiTrans('Dependendo do tipo de dado, podemos atuar como Controlador ou Processador:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Dados de Visitante/Usuário: Controlador', $locale) }}</li>
    <li>{{ aiTrans('Dados de Parceiro: Processador', $locale) }}</li>
    <li>{{ aiTrans('Todos os dados são hospedados de maneira segura, seguindo os mais altos padrões de segurança, com a implementação de salvaguardas físicas, técnicas e organizacionais.', $locale) }}</li>
</ul>
<h4>{{ aiTrans('3.4. Proteção de Dados de Terceiros', $locale) }}</h4>
<p>{{ aiTrans('Quando os Serviços envolvem o processamento de Dados Pessoais em plataformas de terceiros, seguimos as diretrizes específicas:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Atuamos como Processador', $locale) }}</li>
    <li>{{ aiTrans('Cumprimos as instruções do terceiro', $locale) }}</li>
    <li>{{ aiTrans('Implementamos medidas de segurança adequadas', $locale) }}</li>
    <li>{{ aiTrans('Informamos sobre violações de dados', $locale) }}</li>
    <li>{{ aiTrans('Não subcontratamos sem o devido consentimento', $locale) }}</li>
    <li>{{ aiTrans('Não processamos dados fora do Espaço Econômico Europeu sem consentimento', $locale) }}</li>
    <li>{{ aiTrans('Em comunicações de marketing eletrônico, garantimos consentimento e opções de cancelamento.', $locale) }}</li>
</ul>
<h3>{{ aiTrans('4. Segurança', $locale) }}</h3>
<p>
    {{ aiTrans('Adotamos salvaguardas administrativas, organizacionais e técnicas para proteger os Dados Pessoais contra acesso não autorizado, divulgação, alteração, perda, uso indevido ou danos. Quando compartilhamos dados com terceiros, asseguramos que eles mantenham os mesmos padrões de proteção, estabelecendo obrigações contratuais para garantir o processamento seguro e exclusivo, conforme esta Política.', $locale) }}
</p>
<p>
    {{ aiTrans('Se houver suspeita de que sua interação conosco foi comprometida, Visitantes, Usuários ou Parceiros devem nos informar imediatamente. Embora adotemos medidas de segurança, não podemos garantir proteção total contra ataques externos. Os Usuários reconhecem os riscos inerentes e as possíveis falhas de segurança.', $locale) }}
</p>
<h3>{{ aiTrans('5. Cookies', $locale) }}</h3>
<p>
    {{ aiTrans('Consulte nossa', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('Política de Cookies', $locale) }}</a> {{ aiTrans('para mais detalhes sobre os tipos de cookies e tecnologias de rastreamento utilizados no Site, suas finalidades e como aceitá-los ou rejeitá-los.', $locale) }}
</p>
<h3>{{ aiTrans('6. Links para Outros Sites', $locale) }}</h3>
<p>
    {{ aiTrans('Durante a navegação no Site, os Usuários podem encontrar links para sites de terceiros sobre os quais não temos controle. Não nos responsabilizamos pelo conteúdo ou pelas políticas de privacidade desses sites. Recomendamos que os Usuários revisem as políticas de privacidade de tais sites e serviços antes de compartilhar qualquer Dado Pessoal.', $locale) }}
</p>
<h3>{{ aiTrans('7. Retenção e Exclusão', $locale) }}</h3>
<p>
    {{ aiTrans('Os dados, incluindo Dados Pessoais, não serão retidos por mais tempo do que o necessário. Visitantes e Usuários com contas ativas são responsáveis por excluir os dados conforme necessário. Após o término de uma conta ou parceria, os Dados Pessoais coletados serão excluídos de acordo com as leis aplicáveis e nossas políticas internas.', $locale) }}
</p>
<p>
    {{ aiTrans('A revogação do consentimento para o processamento de Dados Pessoais pode restringir o acesso a alguns ou todos os Serviços solicitados, sem que haja direito a reclamações ou contestações.', $locale) }}
</p>
<h3>{{ aiTrans('8. Seus Direitos', $locale) }}</h3>
<p>{{ aiTrans('Os Usuários têm direitos específicos sobre seus Dados Pessoais:', $locale) }}</p>
<h4>{{ aiTrans('8.1. Direito de Acesso', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Confirmar se os Dados Pessoais estão sendo processados', $locale) }}</li>
    <li>{{ aiTrans('Acessar os Dados Pessoais e informações relacionadas', $locale) }}</li>
    <li>{{ aiTrans('Obter informações sobre os fins do processamento, categorias, destinatários, duração do armazenamento, direitos e existência de perfis', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.2. Direito à Retificação', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Corrigir Dados Pessoais imprecisos', $locale) }}</li>
    <li>{{ aiTrans('Completar Dados Pessoais incompletos', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.3. Direito ao Apagamento', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Solicitar a exclusão de Dados Pessoais em circunstâncias específicas', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.4. Direito de Restrição ao Processamento', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Pedir a restrição do processamento em determinadas situações', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.5. Direito à Portabilidade de Dados', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Receber os Dados Pessoais em um formato estruturado e legível por máquina', $locale) }}</li>
    <li>{{ aiTrans('Transmitir os Dados Pessoais para outro controlador', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.6. Direito de Oposição', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Opor-se ao processamento com base em interesses legítimos ou marketing direto', $locale) }}</li>
    <li>{{ aiTrans('Interromper o processamento, salvo se houver motivos convincentes e/ou legais aplicáveis', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.7. Direito de Retirar Consentimento', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Retirar o consentimento para o processamento de Dados Pessoais a qualquer momento', $locale) }}</li>
</ul>
<h3>{{ aiTrans('9. Materiais Publicitários e de Marketing', $locale) }}</h3>
<p>
    {{ aiTrans('Obtivemos seu consentimento para o uso de Dados Pessoais e informações de contato para fornecer materiais publicitários e de marketing. Você pode retirar seu consentimento a qualquer momento, enviando um aviso por e-mail para o endereço fornecido.', $locale) }}
</p>
<h3>{{ aiTrans('10. Aceitação desta Política', $locale) }}</h3>
<p>
    {{ aiTrans('Ao utilizar o Site e/ou os Serviços, Visitantes, Usuários e/ou Parceiros são considerados como tendo lido e aceito esta Política. Caso não concorde, deverá se abster de utilizar a plataforma. Reservamo-nos o direito de modificar esta Política, e recomendamos que os Usuários verifiquem periodicamente as atualizações. O uso contínuo após as alterações será considerado como aceitação.', $locale) }}
</p>
<h3>{{ aiTrans('11. Obrigação Legal de Divulgar Dados Pessoais', $locale) }}</h3>
<p>
    {{ aiTrans('Os Dados Pessoais podem ser divulgados sem consentimento prévio se houver a necessidade de estabelecer a identidade, entrar em contato ou iniciar ações legais contra indivíduos suspeitos de infringir direitos ou propriedades. A divulgação será feita conforme exigido por lei.', $locale) }}
</p>
<h3>{{ aiTrans('12. Encarregado de Proteção de Dados', $locale) }}</h3>
<p>
    {{ aiTrans('Para questões relacionadas à privacidade e proteção de dados, um "Encarregado de Proteção de Dados" foi designado e pode ser contatado pelo e-mail', $locale) }} <span>info{{ '@'.$website_title }}</span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>
        </div>
    </div>
</div>
@endsection
