<?php

namespace App\Http\Controllers\Frontend;

use App\Domain\Core\Models\Article;
use App\Http\Controllers\Controller;
use App\Services\OpenAITranslationService;
use Codebase\PageBuilder\Models\StaticPage;
use Codebase\PageBuilder\PageBuilder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Session;
use SEOMeta;
class HomeController extends Controller
{

    protected $translationService;

    public function __construct(OpenAITranslationService $translationService)
    {
        $this->translationService = $translationService;
    }

    public function home($country = null)
    {
        $country = $country ?? 'en';
        // Check if 'en' is explicitly in the URL and if so, redirect to the main domain (no 'en' in the URL)
        if($country === 'en' && request()->segment(1) === 'en') {
            return redirect()->to(url('/'),301);
        }
        $viewExists = view()->exists('frontend.' . $country . '.home');
        return $viewExists ? view('frontend.' . $country . '.home') : abort(404);
    }

    public function about($country = null)
    {
        $country = $country ?? 'en';
        // Check if 'en' is explicitly in the URL and if so, redirect to the main domain (no 'en' in the URL)
        if($country === 'en' && request()->segment(1) === 'en') {
            return redirect()->to(url('/about'),301);
        }
        // Check if the view exists for the specified country
        $viewExists = view()->exists('frontend.' . $country . '.about');
        // If the view exists, return it, otherwise show 404
        return $viewExists ? view('frontend.' . $country . '.about') : abort(404);
    }
    public function thankYou($country)
    {
        return view('frontend.'.$country . '.thank-you');
    }
    public function contact($country = null)
    {
        $country = $country ?? 'en';
        // Check if 'en' is explicitly in the URL and if so, redirect to the main domain (no 'en' in the URL)
        if($country === 'en' && request()->segment(1) === 'en') {
            return redirect()->to(url('/contact'),301);
        }
        // Check if the view exists for the specified country
        $viewExists = view()->exists('frontend.' . $country . '.contact');
        // If the view exists, return it, otherwise show 404
        return $viewExists ? view('frontend.' . $country . '.contact') : abort(404);
    }
    public function privacy($country = null)
    {
        $country = $country ?? 'en';
        // Check if 'en' is explicitly in the URL and if so, redirect to the main domain (no 'en' in the URL)
        if($country === 'en' && request()->segment(1) === 'en') {
            return redirect()->to(url('/privacy-policy'),301);
        }
        // Check if the view exists for the specified country
        $viewExists = view()->exists('frontend.' . $country . '.privacy');
        // If the view exists, return it, otherwise show 404
        return $viewExists ? view('frontend.' . $country . '.privacy') : abort(404);
    }
    public function terms($country =null)
    {
        $country = $country ?? 'en';
        if($country === 'en' && request()->segment(1) === 'en') {
            return redirect()->to(url('/terms-of-use'),301);
        }
        // Check if the view exists for the specified country
        $viewExists = view()->exists('frontend.' . $country . '.terms');
        // If the view exists, return it, otherwise show 404
        return $viewExists ? view('frontend.' . $country . '.terms') : abort(404);
    }

    public function translateHtml(Request $request)
    {
        $validated = $request->validate([
            'html' => 'required|string',
            'language' => 'required|string'
        ]);

        $translatedHtml = $this->translationService->translateHtml($validated['html'], $validated['language']);

        return response()->json([
            'translatedHtml' => $translatedHtml,
        ]);

        $validated = $request->validate([
            'text' => 'required|string',
            'language' => 'required|string'
        ]);


    }

    public function setLanguage($lang)
    {

        // Validate the language input
        if (in_array($lang, langs() )) {
            Session::put('locale', $lang);
        }

        // Redirect back to the previous page
        return redirect()->back();
    }

}
