<?php

namespace App\Http\Resources\API\Core;

use App\Domain\Core\Actions\GetAvailableTimesAction;
use App\Domain\Core\Models\Branch;
use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class BranchResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {

        $data = [
            'id' => $this->id,
            'title' => $this->title,
            'lat' => $this->lat,
            'lng' => $this->lng,
            'map_desc' => $this->map_desc,
            'phone' => $this->phone,
        ];
        if (request('with_dates')) {
            $branch = Branch::find($this->id);
            $data['available_times'] = (new GetAvailableTimesAction())($branch);
        }
        return $data;
    }
}
