@props(['route', 'model' ,'name', 'routesList', 'id', 'parameters' => [], 'readOnly' => false, 'files' => true, 'breadcrumbs' => null, 'wrapperClass' => null])
@php
    // $routesList = is_array($route) ? $route : null ;
    $model = $model ?? Form::getModel();

    $title = $model ? "Edit {$name}" : "Create {$name}";
@endphp
<x-ui::layout :title="__($title)" :breadcrumbs="$breadcrumbs">
    {{ $prepend ?? '' }}

    <div class="card">
        <div id="{{ $id ?? $name . '-form' }}" class=" card-body ">
            @if ($model)
                @isset($routesList['update'])
                    {!! Form::model($model, [
                        'id' => 'crud-modal-form',
                        'url' => $routesList['update'],
                        'method' => 'PUT',
                        'files' => $files,
                    ]) !!}
                @else

                    {!! Form::model($model, [
                        'id' => 'crud-modal-form',
                        'route' => [$route . '.update', $model->{$model->getKeyName()}],
                        'method' => 'PUT',
                        'files' => $files,
                    ]) !!}

                @endisset
            @else
                @isset($routesList['create'])
                        
                    {!! Form::open(['id' => 'crud-modal-form', 'url' => $routesList['create'], 'files' => $files]) !!}
                @else
                    {!! Form::open(['id' => 'crud-modal-form', 'route' => $route . '.store', 'files' => $files]) !!}

                @endisset
            @endif
            <div class="{{ $wrapperClass }}">
                {{ $slot }}
            </div>
            {!! Form::close() !!}
        </div>
    </div>

    {{ $append ?? '' }}

    <x-slot:actions>
        @isset($actions)
            {{ $actions }}
        @else
            @if (!$readOnly)
                <button form="crud-modal-form" type="submit" class="btn btn-success mx-2 px-5">
                    <i class="fa fa-save"></i> {{ __('Save Data') }}
                </button>
            @endif
            {{ $betweenActions ?? '' }}
            @isset($routesList['index'])
                <a href="{{ $routesList['index'] }}" class="btn btn-secondary">
                    <i class="fa fa-arrow-left"></i> {{ __('Go Back') }}
                </a>
            @else
                <a href="{{ route($route . '.index', $parameters) }}" class="btn btn-secondary">
                    <i class="fa fa-arrow-left"></i> {{ __('Go Back') }}
                </a>

            @endisset
            @endif
        </x-slot:actions>
        <x-slot:header>
            {{ $header ?? '' }}
        </x-slot:header>
        <x-slot:scripts>
            {{ $scripts ?? '' }}
        </x-slot:scripts>
        
    </x-ui::layout>
