@props(['name','icon'=>'','url'])
<div class="menu-item">

    @php
        $keywordsToRemove = ['index',  'edit', 'show'];
        $routeName = app('router')->getRoutes()->match(request()->create($url))->getName();
        // Remove keywords from the route name
        foreach ($keywordsToRemove as $keyword) {
        // Use a regular expression to match the keyword with word boundaries
        $routeName = preg_replace("/\b$keyword\b/i", '', $routeName);
        }
        // Remove extra dots at the beginning or end of the route name
        $routeName = trim($routeName, '.');
    @endphp


    <a class="menu-link @if(request()->routeIs($routeName.'.*')) active @endif" href="{{ $url }}">
        @if(filled($icon))
            <span class="menu-bullet">
            <span class="{{ $icon }}"></span>
        </span>
        @endif
        <span class="menu-title">{{ $name }}</span>
    </a>
</div>