@extends('layouts.app')
@section('title', $website_title .' | ΣΧΕΤΙΚΑ ΜΕ ΕΜΑΣ')
@php( $meta_description = "Ανακαλύψτε πώς το ". $website_title." σας βοηθά να αναπτύξετε τις επενδυτικές σας δεξιότητες στα κρυπτονομίσματα. Προσφέρουμε προηγμένα εργαλεία και πλήρη υποστήριξη για να επιτύχετε τους στόχους σας στις συναλλαγές.")

@section('content')
<div class="what-is w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/what-is-img.webp"  sizes="(max-width: 991px) 100vw, (max-width: 2870px) 50vw, 1435px" alt="{{$website_title}}  - Τι ακριβώς είναι οι διαδικτυακές συναλλαγές;" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h1 class="about-title">{{aiTrans('Σχετικά με εμάς')}}</h1>
        <h2 class="about-subtitle">{{aiTrans('Τι ακριβώς είναι οι διαδικτυακές συναλλαγές;')}}</h2>
        <p>{{aiTrans('Οι διαδικτυακές συναλλαγές ξεκίνησαν το 1971, όταν κυκλοφόρησε το πρώτο λογισμικό συναλλαγών, το National Association of Securities Dealers Automated Quotations (NASDAQ), ως το πρώτο διαδικτυακό λογισμικό συναλλαγών. Σήμερα, οι διαδικτυακές συναλλαγές είναι ο πιο δημοφιλής τρόπος αγοράς και πώλησης διάφορων χρηματοοικονομικών περιουσιακών στοιχείων, όπως Forex, κρυπτονομίσματα, μετοχές, εμπορεύματα και ακόμα και συμβόλαια διαφορών (CFDs).')}}</p>
        <p>
            
            {{ aiTrans(
                "Με βάση αυτό, γεννήθηκε το [website_title] .",
                $locale,
                ['website_title' => $website_title],
            ) }}</p>
        <p>{{aiTrans('Το ισχυρό και έξυπνο λογισμικό συναλλαγών είναι ικανό να εκμεταλλεύεται τις μικρές διαφορές τιμών των ψηφιακών νομισμάτων μεταξύ διαφορετικών ανταλλακτηρίων. Στη συνέχεια, αγοράζει κρυπτονομίσματα σε χαμηλή τιμή και τα πουλά σε υψηλότερη. Το τελικό αποτέλεσμα είναι μικρά κέρδη που οδηγούν σε σημαντικά κέρδη για τον χρήστη.')}}</p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Παρακολουθήστε το βίντεο')}}</a>
        </div>
    </div>
    <div class="what-is-bg-1"></div>
</div>

<div class="how-it-working wf-section">
    <div class="container w-container">
        <div class="how-it-working-text">
            
            {{ aiTrans(
                "Τα κρυπτονομίσματα είναι εξαιρετικά ασταθή περιουσιακά στοιχεία και είναι σημαντικό να λαμβάνετε σωστές αποφάσεις κατά τις συναλλαγές. Αυτό ακριβώς κάνει το [website_title] . Η ισχυρή εφαρμογή διασφαλίζει ότι οι επενδυτές κρυπτονομισμάτων έχουν γρήγορη και σχετική πρόσβαση σε πληροφορίες κατά τις συναλλαγές των αγαπημένων τους νομισμάτων και tokens. Με αυτόν τον τρόπο, μπορούν να εντοπίζουν τις καλύτερες ευκαιρίες στις αγορές κρυπτονομισμάτων και να λαμβάνουν ακριβείς και ενημερωμένες αποφάσεις συναλλαγών κάθε στιγμή. Το [website_title] ουσιαστικά διασφαλίζει ότι κανένας επενδυτής δεν διαπραγματεύεται στα τυφλά. Η εφαρμογή σας επιτρέπει να πραγματοποιείτε συναλλαγές με αυτοπεποίθηση και να αξιοποιείτε στο έπακρο τη δραστηριότητά σας στις αγορές.",
                $locale,
                ['website_title' => $website_title],
            ) }}</div>
    </div>
</div>

<div class="our-team w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/our-team-img.webp"  sizes="(max-width: 991px) 100vw, 50vw" alt="{{$website_title}}  - Ομάδα {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-team-title">
            {{ aiTrans(
                "Ομάδα [website_title] ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "Η ομάδα [website_title] αποτελείται από αφοσιωμένους επαγγελματίες συναλλαγών που επιθυμούν να προσφέρουν σε καθημερινούς ανθρώπους, όπως εσείς, την ευκαιρία να διαπραγματευτούν Bitcoin και άλλα κρυπτονομίσματα αποτελεσματικά και κερδοφόρα. Η ομάδα συνδύασε τη γνώση και την εμπειρία της για να δημιουργήσει μια λύση λογισμικού συναλλαγών που μπορεί να σαρώσει εύκολα και γρήγορα τις διάφορες αγορές κρυπτονομισμάτων και να εντοπίσει κερδοφόρες ευκαιρίες συναλλαγών. Όλη η διαδικασία είναι αυτοματοποιημένη, επιτρέποντας σε οποιονδήποτε να συμμετέχει στις αγορές και να κερδίσει το μερίδιό του από αυτήν την κερδοφόρα βιομηχανία.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "Το [website_title] προσφέρει πολλά οφέλη και πλεονεκτήματα και δεσμευόμαστε πάντα να συμβάλλουμε θετικά στην εμπορική σας εμπειρία και οικονομική πορεία.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Εγγραφείτε τώρα')}}</a>
        </div>
    </div>
</div>
<div class="our-advantage w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/advantage-img.webp"  alt="{{$website_title}}  - Εκμεταλλευτείτε τις αγορές κρυπτονομισμάτων και κερδίστε με το {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-advantage-title">
            {{ aiTrans(
                "Εκμεταλλευτείτε τις αγορές κρυπτονομισμάτων και κερδίστε με το [website_title] ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "Στο [website_title], θέλουμε να σας βοηθήσουμε να επιτύχετε οικονομική ελευθερία και καθώς η αγορά των κρυπτονομισμάτων αναπτύσσεται, δεν υπάρχει αμφιβολία ότι περισσότερες ευκαιρίες συναλλαγών θα εμφανιστούν. Αυτό σημαίνει απλά περισσότερα κέρδη για εσάς.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "Αναλάβετε τον έλεγχο του μέλλοντός σας σήμερα και εγγραφείτε στο [website_title]. Η επιτυχία σας θα αλλάξει τη ζωή σας. Εγγραφείτε τώρα για τον δωρεάν λογαριασμό σας και ξεκινήστε τις συναλλαγές σήμερα!",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
    </div>
</div>
@endsection
