@extends('layouts.app')
@section('title', $website_title .' | MEISTÄ')
@php( $meta_description = "Löydä, miten ". $website_title." auttaa kehittämään kryptovaluutta-sijoittamistaitojasi. Tarjoamme kehittyneitä työkaluja ja täydellistä tukea kaupankäyntitavoitteidesi saavuttamiseksi.")

@section('content')
<div class="what-is w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/what-is-img.webp"  sizes="(max-width: 991px) 100vw, (max-width: 2870px) 50vw, 1435px" alt="{{$website_title}}  - Mitä tarkalleen ottaen on verkkomarkkinointi?" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h1 class="about-title">{{aiTrans('Meistä')}}</h1>
        <h2 class="about-subtitle">{{aiTrans('Mitä tarkalleen ottaen on verkkomarkkinointi?')}}</h2>
        <p>{{aiTrans('Verkkomarkkinointi alkoi vuonna 1971, kun ensimmäinen kaupankäynnin ohjelmisto, National Association of Securities Dealers Automated Quotations (NASDAQ), julkaistiin ensimmäisenä verkkomarkkinoinnin ohjelmistona. Nykyään verkkomarkkinointi on suosituin tapa ostaa ja myydä erilaisia rahoitusomaisuutta, kuten Forex, kryptovaluutat, osakkeet, raaka-aineet ja jopa CFD:t (Contract for Differences).')}}</p>
        <p>
            {{ aiTrans(
                "Tämän perusteella syntyi [website_title] .",
                $locale,
                ['website_title' => $website_title],
            ) }}</p>
        <p>{{aiTrans('Tehokas ja intuitiivinen kaupankäynnin ohjelmisto pystyy hyödyntämään pieniä hintojen eroja digitaalisessa valuutassa eri pörsseissä. Sitten se ostaa kryptovaluuttoja alhaiseen hintaan ja myy ne korkeammalla hinnalla. Lopputulos on pieniä voittoja, jotka johtavat suuriin voittoihin käyttäjälle.')}}</p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Katso video')}}</a>
        </div>
    </div>
    <div class="what-is-bg-1"></div>
</div>

<div class="how-it-working wf-section">
    <div class="container w-container">
        <div class="how-it-working-text">
            
            {{ aiTrans(
                "Kryptovaluutat ovat erittäin epävakaita omaisuuseriä, ja on tärkeää tehdä hyviä päätöksiä niitä kaupankäydessä. Tämä on se, mitä [website_title] tarkoittaa. Tehokas sovellus takaa, että kryptovaluuttasijoittajat voivat saada nopeaa ja relevanttia tietoa ostaessaan ja myydessään suosikkivaluutoitaan ja tokeneitaan markkinoilla. Tällä tavalla he voivat seurata parhaita mahdollisuuksia kryptovaluuttamarkkinoilla ja tehdä tarkkoja ja informoituja kaupankäyntipäätöksiä koko ajan. [website_title] takaa periaatteessa, että mikään kryptosijoittaja ei tee sokeita kauppoja. Sovellus antaa sinulle mahdollisuuden käydä kauppaa luottamuksella ja hyödyntää kaupankäyntitoimintaasi parhaalla mahdollisella tavalla.",
                $locale,
                ['website_title' => $website_title],
            ) }}</div>
    </div>
</div>

<div class="our-team w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/our-team-img.webp"  sizes="(max-width: 991px) 100vw, 50vw" alt="{{$website_title}}  - Tiimi {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-team-title">
            {{ aiTrans(
                "[website_title] Tiimi ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "[website_title] tiimi koostuu omistautuneista kaupankäynnin ammattilaisista, jotka haluavat tarjota tavallisille ihmisille, kuten sinulle, mahdollisuuden käydä kauppaa Bitcoineilla ja muilla kryptovaluutoilla tehokkaasti ja tuottavasti. Tiimi yhdisti tietämyksensä ja kokemuksensa luodakseen kaupankäynnin ohjelmistoratkaisun, joka voi skannata helposti ja nopeasti eri kryptovaluuttapörssejä ja tunnistaa tuottoisia kaupankäyntimahdollisuuksia. Koko prosessi on automatisoitu, joten kuka tahansa voi käydä kauppaa ja saada osansa tästä tuottoisasta kakusta.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "[website_title] tarjoaa monia etuja ja hyötyjä, ja olemme aina sitoutuneet myönteisesti edistämään kaupankäyntikokemustasi ja taloudellista matkaasi.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Rekisteröidy nyt')}}</a>
        </div>
    </div>
</div>
<div class="our-advantage w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/advantage-img.webp"  alt="{{$website_title}}  - Hyödynnä kryptovaluuttamarkkinat ja ansaitse {{$website_title}} kanssa " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-advantage-title">
            {{ aiTrans(
                "Hyödynnä kryptovaluuttamarkkinat ja ansaitse [website_title] kanssa ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "[website_title] haluaa auttaa sinua saavuttamaan taloudellisen vapauden, ja kun kryptovaluuttamarkkinat kasvavat ja kehittyvät, ei ole epäilystäkään siitä, että lisää kaupankäyntimahdollisuuksia tulee esiin. Tämä tarkoittaa yksinkertaisesti enemmän voittoa sinulle.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "Ota hallinta tulevaisuudestasi tänään ja rekisteröidy [website_title] kanssa. Menestyksesi muuttaa elämäsi. Rekisteröidy nyt saadaksesi ilmaisen tilisi ja aloita kaupankäyntitoiminta tänään!",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
    </div>
</div>
@endsection
