@extends('layouts.app')
@section('title', $website_title .' | Mga Tuntunin at Kundisyon')
@php( $meta_description = "Basahin ang mga tuntunin at kundisyon ng ". $website_title.". Ipinaliwanag ng aming mga tuntunin ang iyong mga karapatan, responsibilidad, at kung paano gamitin ang aming mga serbisyo nang ligtas at epektibo.")


@section('content')
<div class="terms-and-conditions wf-section">
        <div class="w-container">
            <h1>MGA TUNTUNIN AT KONDISYON</h1>
            <div>
                <style>
                    table {
                        width: 100%;
                    }
    
                    table,
                    th,
                    td {
                        border: 1px solid;
                        border-collapse: collapse;
                    }
    
                    th,
                    td {
                        padding: 10px;
                    }
    
                    table td {
                        vertical-align: top;
                    }
    
                    .nested-list {
                        counter-reset: item;
                    }
    
                    .nested-list li {
                        display: block;
                    }
    
                    .nested-list li:before {
                        content: counters(item, '.') '. ';
                        counter-increment: item;
                    }
    
                    .legal-section {
                        text-align: left;
                    }
    
                    .legal-section h3 {
                        margin-top: 30px;
                        font-size: 24px;
                    }
    
                    .legal-section h4 {
                        font-size: 18px;
                    }
                </style>

<p>
    {{aiTrans('Salamat sa pagbisita sa aming')}} <a href="{{ route('home', $country) }}">website</a> {{aiTrans('(ang “Website”) kung saan nahanap mo ang link sa mga Tuntunin at Kondisyon na ito (ang “Website”), at aming')}} <a href="{{ route('privacy', $country) }}">{{aiTrans('Patakaran sa Privacy')}}</a> {{aiTrans('(ang "Patakaran sa Privacy"). Ang website na ito ay pinapatakbo at kinokontrol ng')}} {{ $website_title }}{{aiTrans(' at anumang mga kumpanya ng parent, subsidiary, o kaugnay na entidad, na tinutukoy kolektibo bilang')}} {{ $website_title }}. {{aiTrans('Ang Website ay pag-aari namin
                    (na tinutukoy kolektibong bilang “kami”, “aming” o “kami”) at maaari mo kaming kontakin anumang oras sa pamamagitan ng email')}}
                    para: <span >info{{ '@'.$website_title }}</span>
</p>
<p>
    {{ aiTrans('Sa pag-access sa Website o paggamit ng aming mga produkto at/o serbisyo ("Mga Serbisyo ng Tagapagbigay" at kolektibong kasama ang Mga Serbisyo ng Subscription, na tinutukoy bilang "Mga Serbisyo"), sumasang-ayon kang sumunod sa mga Tuntunin ng Paggamit na ito ("Mga Tuntunin") at ang aming Patakaran sa Privacy. Kasama sa mga Tuntunin na ito ang mga patakaran sa operasyon, mga impormasyon, at iba pang mga karagdagang tuntunin. Inilalaan namin ang karapatan na baguhin ang mga Tuntunin paminsan-minsan nang walang paunang abiso at sa aming sariling pagpapasya. Responsibilidad mong suriin paminsan-minsan ang pahinang ito para sa mga update ng mga Tuntunin, na magkakaroon ng bisa pagkatapos mailathala. Ang iyong patuloy na paggamit ng Website ay ituturing na pagtanggap sa mga Tuntunin.', $locale) }}
</p>
<p>
    {{ aiTrans('Mangyaring suriin nang mabuti ang buong mga Tuntunin at Kondisyon na ito. Kung hindi ka sumasang-ayon sa anumang bahagi ng mga ito, hindi ka pinahihintulutan na gamitin ang mga Serbisyo o ang Website sa anumang paraan. Inilalaan namin ang karapatan na tanggihan ang pag-access sa mga Serbisyo at/o Website sa aming sariling pagpapasya.', $locale) }}
</p>
<h3>{{ aiTrans('WALANG PAG-AALAGA SA PAMUMUHUNAN', $locale) }}</h3>
<p>
    {{ aiTrans('Maliban kung tahasang inilahad, ang website na ito ay hindi idinisenyo upang magbigay ng personal na payo sa pananalapi o pamumuhunan. Ang impormasyong ibinigay ay hindi isinasaalang-alang ang iyong mga tiyak na layunin sa pamumuhunan, iyong kalagayang pinansyal, o iyong mga pangangailangan sa pamumuhunan.', $locale) }}
</p>
<p>
    {{ aiTrans('Dapat mong tasahin kung ang impormasyong nasa website na ito ay angkop para sa iyong mga layunin sa pamumuhunan, kalagayang pinansyal, at mga pangangailangan sa pamumuhunan. Dapat mong gawin ito bago gumawa ng desisyon sa pamumuhunan batay sa impormasyong ibinigay sa website na ito. Maaari mong gawin ang pagsusuri na ito nang mag-isa o humingi ng propesyonal na tulong mula sa isang independiyenteng tagapayo sa pananalapi.', $locale) }}
</p>
<p>
    {{ aiTrans('Maliban kung tahasang inilahad, ang impormasyong nakapaloob sa website na ito ay hindi bumubuo ng rekomendasyon ng pamumuhunan sa anumang mga produkto o serbisyong pinansyal na inaalok ng anumang miyembro ng grupong kumpanya ng IG.', $locale) }}
</p>
<h3>{{ aiTrans('PRODUKTO AT MGA SERBISYO', $locale) }}</h3>
<p>
    {{ aiTrans('Hindi lahat ng mga produkto at serbisyo na binanggit sa website na ito ay kinakailangang ibinibigay namin. Ang pagtukoy o paggamit ng anumang produkto, serbisyo, website o network ng ikatlong partido ay hindi bumubuo ng rekomendasyon ng mga produktong, serbisyo, website, o mga network na iyon. Ang website na ito ay maaaring pahintulutan ka na mag-access ng mga website at mga network na ibinibigay ng mga tao na hindi kami sa pamamagitan ng hyperlink o iba pang link.', $locale) }}
</p>
<p>
    {{ aiTrans('Wala kaming tinatanggap na anumang pananagutan o obligasyon ng anumang uri kaugnay ng anumang materyales sa anumang website o network na hindi nasa ilalim ng aming direktang kontrol. Kinikilala mo na ang iyong pag-access sa mga ibang website o network sa pamamagitan ng ganoong link ay maaaring mangailangan sa amin na magbigay ng ilang impormasyon tungkol sa iyo sa may-ari ng website o network na iyon. Wala sa website na ito ang layuning maging, o dapat mong ituring bilang, aming payo sa pamumuhunan o pananalapi o ng amin.', $locale) }}
</p>
<h3>{{ aiTrans('SCOPE AT PAGBAGO', $locale) }}</h3>
<p>
    {{ aiTrans('Sumasang-ayon ka sa mga kondisyon na inilarawan sa dokumentong ito kaugnay ng paggamit ng aming Website. Ang mga Tuntunin na ito ay bumubuo ng kabuuang kasunduan sa pagitan mo at sa amin, na pinapalitan ang lahat ng naunang kasunduan, representasyon, garantiya, at mga pagkaunawaan kaugnay ng Website.', $locale) }}
</p>
<p>
    {{ aiTrans('Mangyaring tandaan na ang mga Tuntunin na ito ay maaaring baguhin paminsan-minsan. Kung binago namin ang mga Tuntunin na ito, ipapaalam namin sa iyo ang mga opsyon na available bilang resulta ng mga pagbabagong ito. Bilang karagdagan, maglalathala kami ng abiso na nagsasaad ng pagbabago. Ang patuloy na paggamit ng Website at/o ng aming mga Serbisyo ay nangangahulugang kumpleto mong tinatanggap na sumunod sa mga na-update na mga tuntunin at kondisyon na umiiral sa oras na iyon. Responsibilidad mong suriin ang pahinang ito paminsan-minsan para sa mga update at/o pagbabago.', $locale) }}
</p>
<h3>{{ aiTrans('PAGHILING', $locale) }}</h3>
<p>
    {{ aiTrans('Ang Website at aming mga Serbisyo ay magagamit lamang para sa mga indibidwal na kwalipikadong maglagda ng mga legal na kontrata alinsunod sa naaangkop na batas. Hindi sila inilaan para sa paggamit ng mga indibidwal na wala pang labing-walo (18) na taon. Kung ikaw ay wala pang labing-walo (18) na taon, wala kang pahintulot na gamitin at/o i-access ang Website at/o ang mga Serbisyo.', $locale) }}
</p>
<h3>{{ aiTrans('DESKRIPSYON NG MGA SERBISYO', $locale) }}</h3>
<p>
    <i>{{ aiTrans('Mga Serbisyo ng Subscription:', $locale) }}</i> {{ aiTrans('Sa pamamagitan ng pagrerehistro sa Website at pagtanggap ng aming pag-apruba, maaari mong makuha, o subukang makuha, ang mga Serbisyo ng Subscription kapalit ng bayad o nang walang bayad. Ang mga serbisyong ito ay nagbibigay ng nilalaman ng email, teksto, at iba pang mga materyales ("Nilalaman ng Subscription") na may kaugnayan sa online marketing mula sa amin at sa mga third-party na kasosyo ("Mga Third-Party na Tagapagbigay"). Hindi ito isang payo sa pamumuhunan. Nauunawaan mo at sumasang-ayon ka na wala kaming pananagutan o pananagutan sa pagiging tumpak, kumpleto, o angkop ng Nilalaman ng Subscription.', $locale) }}
</p>



<p>
    <i>{{ aiTrans('Serbisyo mula sa Tagapagbigay at mga Ikatlong Partido:', $locale) }}</i> {{ aiTrans('Sa pamamagitan ng pagpuno ng mga registration forms, maaari mong makuha, o subukang makuha, ang mga partikular na produkto at/o serbisyo mula sa Website. Ang mga paglalarawan ng mga produkto at/o serbisyo sa Website ay maaaring ibigay ng mga Ikatlong Partido. Hindi namin ginagarantiya ang katumpakan o kumpletude ng mga naturang paglalarawan. Naiintindihan mo at sumasang-ayon ka na wala kaming pananagutan para sa iyong kakulangan sa pagkuha ng mga produkto at/o serbisyo mula sa Website o mga kasosyong kaakibat, ni sa anumang mga hindi pagkakaunawaan sa mga nagbebenta ng mga produkto, distributor, o mga ikatlong partido na may kaugnayan sa website.', $locale) }}
</p>
<p>
    <i>{{ aiTrans('Pangkalahatan:', $locale) }}</i> {{ aiTrans('Upang gamitin ang mga Serbisyo, kailangan mong magbigay ng tamang Service Registration data, at inilalaan namin ang karapatan na tanggihan ang mga hindi kumpleto, pandaraya, o hindi katanggap-tanggap na data. Maliban kung tahasang binanggit, anumang mga darating na alok na nagpapahusay sa mga tampok ng Website ay sasailalim sa mga Tuntunin na ito. Sumasang-ayon ka na wala kaming pananagutan sa iyong kakulangan sa paggamit at/o karapat-dapat sa mga Serbisyo at anumang mga pagbabago, suspensyon o pagtigil.', $locale) }}
</p>
<h3>{{ aiTrans('MGA KARAPATAN SA PAGMAMAY-ARI', $locale) }}</h3>
<p>
    {{ aiTrans('Ang Website, ang Nilalaman at ang Mga Serbisyo, kabilang ang organisasyon, mga grapiko, disenyo, kompilasyon, software at iba pang mga bagay, ay protektado ng mga karapatang may kinalaman sa copyright, mga nakarehistrong trademark, at iba pang mga karapatan sa ari-arian na naaangkop. Ang pagkopya, muling pamamahagi o pagbebenta ng anumang bahagi ng Website, Nilalaman at/o Mga Serbisyo ay mahigpit na ipinagbabawal. Ang paggamit ng mga automated na pamamaraan o scraping upang kunin ang materyal para sa anumang layunin nang walang nakasulat na pahintulot ay mahigpit na ipinagbabawal. Wala kang nakuha na mga karapatan sa ari-arian sa anumang nilalaman, dokumento, software, serbisyo o materyales sa Website. Ang aming pangalan, logo, mga graphic, icon at pangalan ng mga serbisyo ay mga nakarehistrong trademark. Ang hindi awtorisadong paggamit ng anumang nakarehistrong trademark ay mahigpit na ipinagbabawal.', $locale) }}
</p>
<h3>{{ aiTrans('KONFIDENSYAL NA IMPORMASYON', $locale) }}</h3>
<p>
    {{ aiTrans('Ang mga konfidensyal na impormasyon ay tumutukoy sa mga ari-arian ng impormasyon na tinukoy bilang ganoon at hindi kasama ang mga impormasyong alam ng publiko, naunang kaalaman, mga impormasyong ipinasok nang mag-isa o mga impormasyong nakuha mula sa mga ikatlong partido nang walang mga paghihigpit sa pagpapahayag. Ang tungkulin ng proteksyon sa mga konfidensyal na impormasyon ay magtatapos isang (1) taon pagkatapos ng pagtatapos.', $locale) }}
</p>
<h3>{{ aiTrans('BANNED HYPERLINKS SA WEBSITE, CO-BRANDING, "FRAMING" AT/OR PAGSUSURI NG WEBSITE', $locale) }}</h3>
<p>
    {{ aiTrans('Ang mga hyperlinks patungo sa Website o mga bahagi nito sa ibang website nang walang aming tahasang pahintulot ay ipinagbabawal. Ang “Framing” ng Website o pagsusuri ng Uniform Resource Locator (“URL”) nang walang aming nakasulat na pahintulot ay mahigpit na ipinagbabawal. Ang kooperasyon upang alisin ang mga ganoong nilalaman o aktibidad ay kinakailangan, at ikaw ay responsable para sa anumang pinsala na nauugnay sa mga ito.', $locale) }}
</p>
<h3>{{ aiTrans('EDITORYAL, PAGBUBURA AT PAGBAGO', $locale) }}</h3>
<p>
    {{ aiTrans('Inilalaan namin ang karapatan na i-edit at/o burahin ang anumang dokumento, impormasyon o nilalaman sa Website nang walang paunang abiso.', $locale) }}
</p>
<h3>{{ aiTrans('WAIVER NG PANANAGUTAN', $locale) }}</h3>
<p>
    {{ aiTrans('Ang WEBSITE, MGA SERBISYO, NILALAMAN AT ANUMANG MGA PRODUKTO NG IKATLONG PARTIDO AY IBINIBIGAY "BILANG-ANO" AT "BILANG-AVAILABLE", NA MAY LAHAT NG MGA WARRANTY, SINAUNANG AT IMPLISITONG, NA HINDI NASASAMA SA PINAKAMATAAS NA EXTENSION NG BATAS. HINDI NAMIN GARANTISADO NA ANG WEBSITE, MGA SERBISYO, NILALAMAN AT/OR MGA PRODUKTO NG IKATLONG PARTIDO AY MAKIKINABANG SA IYONG MGA KAILANGAN O HINDI MAGKAKAROON NG PAGSUBOK, ORAS, SEGURIDAD O WALANG PAGKAKAMALI. SUMASANG-AYON KA NA HINDI KAMI RESPONSABLE SA ANUMANG PAGHAHABI NA KAUGNAY NG KAKULANGAN SA PAGGAMIT NG WEBSITE, MGA SERBISYO, NILALAMAN AT/OR MGA PRODUKTO NG IKATLONG PARTIDO. ANG WEBSITE AY MAARING MAGLAMAN NG MGA BUG, ERROR O MGA LIMITASYON, AT HINDI KAMI RESPONSABLE PARA SA AVAILABILITY NG INTERNET CONNECTION.', $locale) }}
</p>
<h3>{{ aiTrans('LIMITASYON NG PANANAGUTAN', $locale) }}</h3>
<p>
    {{ aiTrans('HINDI KAMI RESPONSABLE PARA SA DIRECT, INDIRECT, INCIDENTAL, SPECIAL O EXEMPLARY DAMAGES, KASAMA NA ANG PAGKAWALA NG KITA, GOODWILL, PAGGAMIT, DATA O IBA PANG INTANGIBLE LOSS. ANG LIMITASYON NA ITO AY NAG-AAPPLY SA LAHAT NG MGA CAUSES NG ACTION, KASAMA NA ANG BREACH NG KONTRATA, WARRANTY, NEGLIGENCE, OBJECTIVE LIABILITY, FALSE STATEMENTS AT ANUMANG IBA PANG KRIMINAL. IKAW AY PUMAYAG NA PALAYAIN KAMI AT ANG AMING MGA IKATLONG PARTNER SA MGA OBLIGASYON, RESPONSIBILIDAD AT CLAIMS HIGIT SA LIMITASYON NA ITO. KUNG ANG BATAS AY HINDI ALLOWED ANG LIMITASYON NA ITO, ANG AMING PINAKAMALALING RESPONSIBILIDAD SA ANUMANG SITUASYON AY HINDI LALAMPAS SA LIMANG DAANG DOLLAR ($500.00).', $locale) }}
</p>
<h3>{{ aiTrans('INDENISAÇÃO', $locale) }}</h3>



<p>
    {{ aiTrans('Sumasang-ayon ka na indemnify at palayain kami, ang aming mga kasosyo, mga subsidiary, mga kaakibat at kanilang mga kaukulang miyembro, mga direktor, mga empleyado, mga ahente at mga kasosyo mula sa anumang mga reklamo, gastusin, pinsala, mga proseso, gastos, kahilingan at/o mga hatol na ginawa ng mga ikatlong partido na dulot o nagmula sa iyong paggamit ng Website, mga Serbisyo o Nilalaman; ang iyong paglabag sa mga Tuntuning ito; at/o ang iyong paglabag sa mga karapatan ng ibang tao at/o entidad.', $locale) }}
</p>
<h3>{{ aiTrans('WEBSITES NG IKATLONG PARTIDO', $locale) }}</h3>
<p>
    {{ aiTrans('Ang Website ay maaaring magbigay ng mga link patungo sa iba pang mga website at/o mga resources sa Internet na pag-aari ng mga Ikatlong Tagapagbigay. Wala kaming pananagutan para sa availability ng mga website at/o mga resources ng ikatlong partido, ni para sa kanilang nilalaman, at hindi namin sinusuportahan o inaako ang responsibilidad para sa kanilang mga tuntunin, mga patakaran sa privacy, nilalaman, advertising, serbisyo, produkto o materyales.', $locale) }}
</p>
<h3>{{ aiTrans('PATAYO NG PRIVASIYA/IMPORMASYON NG MGA BISITA', $locale) }}</h3>
<p>
    {{ aiTrans('Ang iyong paggamit ng Website at lahat ng mga komento, feedbacks, impormasyon, mga datos ng Rehistro at/o mga materyales na isinumite ay sumusunod sa aming Patakaran sa Privacy. Inilalaan namin ang karapatan na gamitin ang impormasyon tungkol sa iyong paggamit ng Website at mga impormasyong makikilala mula sa iyong sarili alinsunod sa aming Patakaran sa Privacy at mga naaangkop na batas sa proteksyon ng datos.', $locale) }}
</p>
<h3>{{ aiTrans('LEGAL NA PAALALA', $locale) }}</h3>
<p>
    {{ aiTrans('Anumang pagtatangka na sirain, wasakin, pakialaman, magdulot ng pinsala o makialam sa operasyon ng Website ay isang paglabag sa mga batas na kriminal at sibil. Hahanapin namin ang mga lunas laban sa sinumang tao o entidad na lumalabag sa maximum na lawak na pinapayagan ng batas at katarungan.', $locale) }}
</p>
<h3>{{ aiTrans('PAGPILI NG BATAS AT HURISDIKSYON', $locale) }}</h3>
<p>
    {{ aiTrans('Ang mga Tuntuning ito ay pinamamahalaan at ipapaliwanag alinsunod sa mga batas ng United Kingdom. Ang mga Partido ay magsisikap na makipagkasunduan sa mabuting pananampalataya para sa anumang mga reklamo o hindi pagkakaunawaan na nagmula o kaugnay ng mga Tuntunin at Kondisyon na ito sa isang magiliw na paraan. Kung ang mga Partido ay hindi makakarating sa isang kasunduan, ang hindi pagkakaunawaan ay ilalagay ng eksklusibo sa mga confidential arbitration procedures sa ilalim ng isang solong arbitrator sa London, alinsunod sa mga alituntunin ng ICC, at ang desisyon ay magiging pinal at may bisa. Walang partido ang maaaring maghain ng reklamo sa lokal na hukuman ng kanilang tinitirahan o anumang ibang hurisdiksyon.', $locale) }}
</p>
<h3>{{ aiTrans('ANNEX NG PROTEKSYON NG DATOS', $locale) }}</h3>
<p>
    {{ aiTrans('Ang Annex na ito ng Proteksyon ng Datos ay bahagi ng aming mga Tuntunin at Kondisyon. Ang mga termino na ginamit dito ay may mga kahulugang tinukoy sa Annex na ito. Maliban kung binago sa ibaba, ang mga Tuntunin ay mananatiling ganap na may bisa at epekto.', $locale) }}
</p>
<ol class="nested-list">
    <li>
        <b>{{ aiTrans('Mga Pagpapakahulugan', $locale) }}</b>
        <ol class="nested-list">
            <li>
                <b>{{ aiTrans('Mga Nalalapat na Batas:', $locale) }}</b> {{ aiTrans('Mga Batas ng EU o ng Member State ukol sa Personal na Datos na napapailalim sa mga Batas ng Proteksyon ng Datos ng EU at iba pang naaangkop na mga batas para sa Personal na Datos na napapailalim sa iba pang mga Batas ng Proteksyon ng Datos.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Kontrolador:', $locale) }}</b> {{ aiTrans('Entity na nagtatakda ng layunin at pamamaraan ng pagproseso ng Personal na Datos.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Mga Batas sa Proteksyon ng Datos:', $locale) }}</b> {{ aiTrans('Mga Batas sa Proteksyon ng Datos ng EU at mga batas sa proteksyon ng datos o privacy mula sa anumang ibang bansa.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Mga Batas sa Proteksyon ng Datos ng EU:', $locale) }}</b> {{ aiTrans('Direktiba 95/46/CE ng EU, GDPR at mga kaugnay na batas.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('GDPR:', $locale) }}</b> {{ aiTrans('General Data Protection Regulation ng EU 2016/679.', $locale) }}
            </li>
        </ol>
    </li>

<li>
    <b>{{ aiTrans('Pagkolekta at Pagproseso ng Personal na Datos', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Sumasang-ayon kaming sumunod sa lahat ng mga Batas sa Proteksyon ng Datos na naaangkop sa Pagproseso ng Personal na Datos.', $locale) }}
            <ol class="nested-list">
                <li>
                    {{ aiTrans('Ipinagpapalagay namin at ginagarantiyahan na mayroon kaming mga kinakailangang pahintulot at kasunduan mula sa mga may-ari ng datos upang pahintulutan ng legal ang pagkolekta, pagproseso at pagbabahagi ng Personal na Datos sa pamamagitan ng mga Serbisyo alinsunod sa mga Nalalapat na Batas.', $locale) }}
                </li>
                <li>
                    {{ aiTrans('Panatilihin namin ang isang mekanismo upang makuha at bawiin ang pahintulot, alinsunod sa mga Nalalapat na Batas, at isang pampublikong patakaran sa privacy na magagamit sa lahat.', $locale) }}
                </li>
                <li>
                    {{ aiTrans('Inilalaan namin na hindi kami nagbibigay ng mga Serbisyo sa mga bata na wala pang labing-walo (18) na taon.', $locale) }}
                </li>
            </ol>
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Seguridad', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Magpapatupad kami ng mga angkop na teknikal at organisasyonal na hakbang para sa seguridad ng datos alinsunod sa Artikulo 32(1) ng GDPR.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Subproseso', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Pinahihintulutan mo kami na magtalaga ng mga Subprocessor at tiyakin na ang mga kontrata sa mga Subprocessor ay magbibigay ng parehong antas ng proteksyon para sa Personal na Datos gaya ng inilarawan sa Annex na ito at tumugon sa mga kinakailangan ng GDPR.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Mga Karapatan ng mga May-ari ng Datos', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Tutulungan naming tumugon sa mga kahilingan ng mga Karapatan ng May-ari ng Datos alinsunod sa mga Batas sa Proteksyon ng Datos, isinasaalang-alang ang likas na katangian ng Pagproseso.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Paglabag sa Personal na Datos', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Agad naming ipapaalam sa mga apektadong May-ari ng Datos kapag kami ay nakatanggap ng Paglabag sa Personal na Datos, tutulungan sila sa pagsisiyasat, pagpapagaan at pagwawasto.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Mga Pangkaraniwang Tuntunin', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Ang mga hindi pagkakaunawaan o reklamo na nagmumula sa mga Tuntuning ito ay sumasailalim sa hurisdiksyon na itinakda rito. Kung ang alinmang probisyon ay hindi wasto, ang natitirang mga probisyon ay mananatiling may bisa.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Pagbabago', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Ang mga pagbabago sa mga Tuntuning ito ay maaaring gawin paminsan-minsan ayon sa aming eksklusibong pagpapasya', $locale) }}
        </li>
    </ol>
</li>
</ol>
<p>
    {{ aiTrans('Sa pamamagitan ng pagtanggap ng mga Tuntuning ito, kinikilala mo na nabasa mo, naintindihan, at sumasang-ayon kang sumunod sa lahat ng mga term at kondisyon na inilarawan sa itaas. Ang iyong patuloy na paggamit ng Website at Serbisyo ay nangangahulugang pagtanggap ng mga kondisyong ito. Kung mayroon kang anumang mga katanungan o alalahanin, makipag-ugnayan sa amin sa pamamagitan ng email sa') }} <span >info{{ '@'.$website_title }}</span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>

        </div>
    </div>
@endsection
