@extends('layouts.app')
@section('title', $website_title .' | プライバシーポリシー')
@php( $meta_description = "どのようにして". $website_title."があなたの個人情報を保護するかをご覧ください。私たちのプライバシーポリシーでは、あなたの情報の安全性と透明性を確保するために講じている措置を詳述しています。")

@section('content')
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>プライバシーポリシー</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
                <b>最終更新日:</b> 9月
            </p>
            <h3>{{ aiTrans('1. はじめに', $locale) }}</h3>
<p>
    {{ aiTrans('この声明は、', $locale) }} {{ $website_title }} ("{{ aiTrans('私たち', $locale) }}," "{{ aiTrans('私たちの', $locale) }}," "{{ aiTrans('または', $locale) }}")
    {{ aiTrans('が提供する製品およびサービス（以下「サービス」）および', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('ウェブサイト', $locale) }}</a>
    {{ aiTrans('（以下「サイト」）に関するプライバシーポリシーを説明したものです。', $locale) }}
    {{ aiTrans('私たちのサービスを提供し、サイトを運営する上で、あなたのプライバシーと情報の機密性を保護することは非常に重要です。', $locale) }}
</p>
<p>
    {{ aiTrans('私たちのサービスとサイトには、第三者のウェブサイトやサービスへのリンクが含まれている場合があります。これらの外部サイトのプライバシー慣行に対して私たちは責任を負いません。それらを利用する前に、プライバシーポリシーをご確認いただくことをお勧めします。', $locale) }}
</p>
<p>
    {{ aiTrans('私たちがサービスに関連して取得するすべての情報は機密として扱われます。私たちは、個人データ（以下で定義）を不正処理、偶発的な喪失、破壊、損傷、盗難、または開示から保護するために、技術的、セキュリティ的、組織的な強固な措置を講じています。', $locale) }}
</p>
<p>
    {{ aiTrans('当サイトを通じて情報を送信する際には、あなたの名前、メールアドレス、電話番号、生年月日、その他の識別情報など、個人情報の提供を求められる場合があります。これらの情報は、本人確認、情報管理、技術サポートの提供、および契約上および法的義務の履行などの目的で使用されることがあります。また、通知を通じて重要な詳細をお知らせする場合があり、あなたの同意が得られた場合には、製品やサービスに関する情報をSMSやメールなどで提供することがあります。通知の設定を管理し、特定の通信を購読解除するオプションも提供されています。', $locale) }}
</p>
<h3>{{ aiTrans('2. サイト; 訪問者とユーザー', $locale) }}</h3>

<h4>{{ aiTrans('2.1. 一般', $locale) }}</h4>
<p>
    {{ aiTrans('このセクションでは、異なるグループからのデータ収集の詳細について説明します：ウェブサイトの訪問者（「訪問者」）、ユーザー（「ユーザー」）、およびビジネスパートナー（総称して「パートナー」）。個人データには、IPアドレス、名前、連絡先の詳細、および当社との関係に関する情報が含まれます。これらは適用されるデータ保護規制に基づいて定義されます。', $locale) }}
</p>
<h4>{{ aiTrans('2.2. データの収集と使用', $locale) }}</h4>
<p>
    {{ aiTrans('サイトを訪問することにより、あなたは個人データの収集と使用に同意したことになります。この条件に同意しない場合、サイトの訪問を避ける必要があります。私たちは、ページビュー活動、IPアドレス、クッキーを通じて情報を収集することがあります。さらに、フォームや登録で自発的に提供されたデータも処理します。', $locale) }}
</p>
<h4>{{ aiTrans('2.3. 個人データの処理目的', $locale) }}</h4>
<p>
    {{ aiTrans('私たちは、サイトとサービスを改善、理解、個別化するために個人データを処理します。これには、正確性を向上させ、サービスに関するコミュニケーション、サポート、契約上の義務、およびパートナーとの協力が含まれます。処理には同意または法的根拠が必要です。', $locale) }}
</p>
<p>{{ aiTrans('以下は、個人データの処理目的と法的根拠について説明しています:', $locale) }}</p>
<table>
    <tbody>
        <tr>
            <td>{{ aiTrans('アカウント所有者としての登録', $locale) }}</td>
            <td>{{ aiTrans('あなたの同意；サービスまたは契約上の義務の履行', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('サービスの提供と使用', $locale) }}</td>
            <td>{{ aiTrans('サービスまたは契約上の義務の履行', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('運用の更新', $locale) }}</td>
            <td>{{ aiTrans('サービスまたは契約上の義務の履行', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('問い合わせへの対応とサポートの提供', $locale) }}</td>
            <td>{{ aiTrans('正当な利益またはサービスの履行', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('サービス、広告、カスタマイズされたマーケティング', $locale) }}</td>
            <td>{{ aiTrans('正当な利益またはあなたの同意', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('新しいサービスの改善と提供', $locale) }}</td>
            <td>{{ aiTrans('同意と正当な利益', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('広告とマーケティング資料の送信', $locale) }}</td>
            <td>{{ aiTrans('あなたの同意', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('マーケティングキャンペーンの効果分析', $locale) }}</td>
            <td>{{ aiTrans('正当な利益または同意', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('さまざまなサポート活動の実行', $locale) }}</td>
            <td>{{ aiTrans('正当な利益またはサービスの履行', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('分析、統計分析を含む', $locale) }}</td>
            <td>{{ aiTrans('正当な利益', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('利益、権利、財産の保護', $locale) }}</td>
            <td>{{ aiTrans('正当な利益または法的義務', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h4>{{ aiTrans('2.4. 個人データの共有', $locale) }}</h4>

<p>
    {{ aiTrans('私たちは、サービス提供者、パートナー、および契約者と情報を共有することがあります。欧州経済地域の訪問者およびユーザーに対して、データ処理はGDPRおよび適用されるデータ保護法に準拠しています。', $locale) }}
</p>
<h3>{{ aiTrans('3. パートナー', $locale) }}</h3>
<h4>{{ aiTrans('3.1. 一般', $locale) }}</h4>
<p>
    {{ aiTrans('サービス提供およびパートナーとの協力のために、特定の種類のデータを収集し、処理します。パートナーは自分のデータに対して責任を負い、安全な手段でアクセスできます。', $locale) }}
</p>
<h4>{{ aiTrans('3.2. 個人データの処理', $locale) }}</h4>
<p>
    {{ aiTrans('私たちは、パートナーの同意または正当な利益に基づいて個人データを処理します。データの集約は、開発と品質向上のために行われることがあります。', $locale) }}
</p>
<h4>{{ aiTrans('3.3. 管理者/処理者', $locale) }}</h4>
<p>{{ aiTrans('私たちは、データの種類に応じて、管理者または処理者として活動することがあります。', $locale) }}</p>
<ul>
    <li>{{ aiTrans('訪問者/ユーザーのデータ：管理者', $locale) }}</li>
    <li>{{ aiTrans('パートナーのデータ：処理者', $locale) }}</li>
    <li>{{ aiTrans('すべてのデータは安全にホスティングされ、最高のセキュリティ基準に従って処理されます。物理的、技術的、組織的な保護措置を講じています。', $locale) }}</li>
</ul>
<h4>{{ aiTrans('3.4. 第三者の個人データの保護', $locale) }}</h4>
<p>{{ aiTrans('サービスが第三者のプラットフォームで個人データを処理する場合、', $locale) }}</p>
<ul>
    <li>{{ aiTrans('私たちは処理者として活動します', $locale) }}</li>
    <li>{{ aiTrans('第三者の指示に従う', $locale) }}</li>
    <li>{{ aiTrans('セキュリティ対策を実施する', $locale) }}</li>
    <li>{{ aiTrans('データ侵害について通知する', $locale) }}</li>
    <li>{{ aiTrans('同意なしで再委託しない', $locale) }}</li>
    <li>{{ aiTrans('欧州経済領域外でデータを処理しない（同意がある場合を除く）', $locale) }}</li>
    <li>{{ aiTrans('電子マーケティングコミュニケーションについて、同意とキャンセルオプションを保証します。', $locale) }}</li>
</ul>
<h3>{{ aiTrans('4. セキュリティ', $locale) }}</h3>
<p>
    {{ aiTrans('私たちは、個人データを不正アクセス、公開、変更、喪失、不正使用、または無断での損傷から保護するために、管理的、組織的、技術的な保護措置を講じています。第三者とデータを共有する際には、同様のデータ保護基準を維持するよう保証し、独占的かつ安全な処理のための契約義務が設定されます。', $locale) }}
</p>
<p>
    {{ aiTrans('私たちとのインタラクションが侵害されたと考えられる場合、訪問者、ユーザー、またはパートナーは速やかに通知する必要があります。セキュリティ対策にもかかわらず、第三者からの攻撃に対して完全な免疫を保証することはできないことにご留意ください。ユーザーは、内在的なリスクと可能性のある違反を認識しています。', $locale) }}
</p>
<h3>{{ aiTrans('5. クッキー', $locale) }}</h3>
<p>
    {{ aiTrans('私たちの', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('クッキーポリシー', $locale) }}</a> {{ aiTrans('を確認して、ウェブサイトで使用されるクッキーとトラッキング技術の種類、使用目的、およびそれらを受け入れる方法または拒否する方法に関する詳細情報をご覧ください。', $locale) }}
</p>
<h3>{{ aiTrans('6. 他のサイトへのリンク', $locale) }}</h3>
<p>
    {{ aiTrans('サイトの閲覧中に、ユーザーは当社の管理外の外部サイトへのリンクに遭遇することがあります。これらのサイトのコンテンツやプライバシーポリシーに対して、私たちは責任を負いません。ユーザーは、個人データを提供する前に、これらの第三者のサイトおよびサービスのプライバシーポリシーを確認することをお勧めします。', $locale) }}
</p>
<h3>{{ aiTrans('7. データの保持と削除', $locale) }}</h3>

<p>
    {{ aiTrans('個人データを含むデータは、必要以上に保持されません。アクティブなアカウントを持つ訪問者および/またはユーザーは、データの適切な削除に責任を負います。アカウントまたはパートナーシップが終了した後、サイトおよび/またはサービスを通じて収集された個人データは、適用される法律および内部ポリシーに従って削除されます。', $locale) }}
</p>
<p>
    {{ aiTrans('個人データの処理に対する同意の撤回は、要求されたサービスの一部またはすべてへのアクセスを制限する場合がありますが、苦情や異議申し立ては適用されません。', $locale) }}
</p>
<h3>{{ aiTrans('8. あなたの権利', $locale) }}</h3>
<p>{{ aiTrans('ユーザーには、個人データに関して特定の権利があります：', $locale) }}</p>
<h4>{{ aiTrans('8.1. アクセス権', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('個人データが処理されているか確認する', $locale) }}</li>
    <li>{{ aiTrans('個人データおよび関連情報にアクセスする', $locale) }}</li>
    <li>{{ aiTrans('処理の目的、カテゴリ、受取人、保存期間、権利およびプロフィールの存在に関する情報', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.2. 修正の権利', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('不正確な個人データを修正する', $locale) }}</li>
    <li>{{ aiTrans('不完全な個人データを補完する', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.3. 削除の権利', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('特定の状況で個人データの削除を要求する', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.4. 処理の制限権', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('特定の状況で処理の制限を受ける', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.5. データの可搬性の権利', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('構造化され、機械可読な形式で個人データを受け取る', $locale) }}</li>
    <li>{{ aiTrans('個人データを別の管理者に転送する', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.6. 反対の権利', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('正当な利益またはダイレクトマーケティングに基づく処理に反対する', $locale) }}</li>
    <li>{{ aiTrans('処理を停止する、ただし説得力のある理由や適用可能な法的根拠がある場合を除く', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.7. 同意撤回の権利', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('個人データの処理に対する同意をいつでも撤回する', $locale) }}</li>
</ul>
<h3>{{ aiTrans('9. 広告およびマーケティング資料', $locale) }}</h3>
<p>
    {{ aiTrans('個人データおよび連絡先詳細を使用して広告およびマーケティング資料を提供するために同意を得ています。同意の撤回は、提供されたメールアドレスに書面で通知することで行うことができます。', $locale) }}
</p>
<h3>{{ aiTrans('10. このポリシーの受け入れ', $locale) }}</h3>
<p>
    {{ aiTrans('サイトおよび/またはサービスを利用することにより、訪問者、ユーザー、またはパートナーはこのポリシーを読み、同意したと見なされます。異議がある場合は、プラットフォームの使用を控える必要があります。私たちはポリシーを変更する権利を保持しており、ユーザーには定期的に更新を確認することをお勧めします。変更後の継続的な使用は、受け入れを示します。', $locale) }}
</p>
<h3>{{ aiTrans('11. 個人データの法的開示義務', $locale) }}</h3>
<p>
    {{ aiTrans('個人データは、個人の権利または財産を侵害した疑いがある場合、または法律によって要求された場合に開示されることがあります。', $locale) }}
</p>
<h3>{{ aiTrans('12. データ保護責任者', $locale) }}</h3>
            <p>
                {{ aiTrans('プライバシーおよびデータ保護に関する質問については、指定された「データ保護責任者」に以下のメールアドレスで連絡できます：', $locale) }}
                <span >info{{ '@'.$website_title }}</span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>


        </div>
    </div>
</div>
@endsection
