@extends('layouts.app')

@section('content')
<div class="hero wf-section">
    <div class="container w-container">
        <h1 class="hero-header">{{$website_title}}</h1>
        <h3 class="hero-subtitle">
            {{ aiTrans(
                "Rewolucjonizowanie handlu kryptowalutami: przedstawiamy najnowszą aktualizację [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
        <div class="main-cols">
            <div class="video-col"><img src="dist/images/poster_index.webp" sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw" srcset="{{ asset('frontend/assets/pt/dist') }}/images/poster_index-p-500.webp 500w, {{ asset('frontend/assets/pt/dist') }}/images/poster_index.webp 733w" alt="{{$website_title}} - Rewolucjonizowanie handlu kryptowalutami: przedstawiamy najnowszą aktualizację {{$website_title}}" width="710" height="399" class="main-image"></div>
            <div class="form-col">
                <div class="form-container">
                    <div id="formTop" class="form-box w-form-wrapper">
                        @include('frontend.pl.components.form')
                        <div class="w-form-done">
                            <div>{{aiTrans('Dziękujemy! Twoje zgłoszenie zostało odebrane!')}}</div>
                        </div>
                        <div class="w-form-fail">
                            <div>{{aiTrans('Ups! Coś poszło nie tak podczas przesyłania formularza.')}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-bg-2"></div>
    <div class="hero-bg-1"></div>
</div>
<div class="trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/trade-image.webp" width="500" alt="{{$website_title}} - Czym jest {{$website_title}}?" class="img-float-right no-float-on-991">
    <div class="container w-container">
        <h2 class="trading-title">
            {{ aiTrans(
                "Czym jest [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="trading-text">
            {{ aiTrans(
                "Z radością ogłaszamy wydanie nowej wersji [website_title] – ostatecznej platformy do handlu kryptowalutami. Z zaawansowanymi funkcjami, nowoczesną technologią i przyjaznym interfejsem, nowe [website_title] zostało zaprojektowane, aby podnieść Twoje doświadczenie handlowe na wyższy poziom. Potężne i intuicyjne oprogramowanie handlowe jest w stanie wykorzystać małe różnice cen kryptowalut między różnymi giełdami. Następnie kupi kryptowaluty po niskiej cenie, a potem sprzeda je po wyższej cenie. Końcowym wynikiem są małe kwoty zysku, które prowadzą do dużych zysków dla użytkownika.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button margin-bottom-35 w-button">{{aiTrans("Zarejestruj się teraz")}}</a>
        </div>
        <h2 class="trading-title">{{aiTrans('Jak zacząć handel online?')}}</h2>
        <div class="trading-text">{{aiTrans('Handel online, podstawowa kupno i sprzedaż aktywów finansowych przez Internet, może być realizowany przez praktycznie każdego, niezależnie od doświadczenia na rynkach finansowych. Choć łatwo zacząć, jeśli chcesz być dochodowy, handel online może być wyzwaniem. Aby zacząć handel online, będziesz potrzebować komputera i niezawodnego połączenia internetowego. Po zarejestrowaniu się na konto handlowe w renomowanej platformie, będziesz mógł zacząć handel, gdy tylko Twoje konto zostanie aktywowane i dofinansowane. Co ciekawe, choć łatwo zacząć handel, dużo trudniej jest odnieść sukces jako trader. Istnieje wiele ryzyk, o których musisz wiedzieć. Wiele handlu polega na metodycznym planowaniu, dokładnej analizie rynku, zrozumieniu czynników wpływających na ceny aktywów oraz na próbach i błędach. Niektóre rynki aktywów mogą być również dość zmienne, co może znacznie zwiększyć ryzyko straty, jeśli nie masz umiejętności wykorzystania wielu możliwości handlowych, które zmienność może oferować. Mimo wyzwań, dzięki postępom technologicznym w technologii algorytmicznej, taki rodzaj oprogramowania handlowego sprawił, że rozpoczęcie handlu online z większą precyzją jest łatwiejsze niż kiedykolwiek. Algorytm aplikacji będzie analizował rynki w celu identyfikacji okazji handlowych, a dzięki tym informacjom będziesz mógł podejmować mądrzejsze decyzje handlowe oparte na analizie rynku. W ten sposób nawet nowi traderzy mogą zacząć handlować swoimi ulubionymi aktywami online.')}}</div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("Zarejestruj się teraz")}}</a>
            <div class="trading-bg2"></div>
        </div>
    </div>
    <div class="trading-bg-1"></div>
</div>
<div class="not-scam w-clearfix wf-section">
    <div class="not-scam-bg-1"></div>
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/not-scam-img.webp" alt="{{$website_title}} - {{$website_title}} to oszustwo?" class="img-float-right not-scam-img">
    <div class="container w-container">
        <h3 class="not-scam-title">
            {{ aiTrans(
                "[website_title] to oszustwo?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
<p class="not-scam-text">
    {{ aiTrans(
        "Nie, to nie jest oszustwo. [website_title] nie obiecuje gwarantowanych zysków z handlu kryptowalutami, ponieważ nie jest to zautomatyzowane oprogramowanie do handlu. Aplikacja jest tylko asystentem handlowym. Została zaprojektowana, aby pomóc inwestorom w handlu kryptowalutami z pewnością siebie. Aplikacja dostarcza informacje oparte na danych w czasie rzeczywistym dla traderów, pomagając im podejmować szybkie i precyzyjne decyzje podczas handlu swoimi ulubionymi kryptowalutami online. Dodatkowo aplikacja jest bezpieczna i nie narusza żadnych danych osobowych ani finansowych swoich klientów.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</p>
<div class="button-wrapper">
    <a href="#formTop" class="button white w-button">{{aiTrans("ZAREJESTRUJ SIĘ TERAZ")}}</a>
</div>
</div>
</div>
<div class="improve-your-trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/improve-your-trading-img.webp" alt="{{$website_title}} - Jak aplikacja {{$website_title}} poprawia Twoje handel?" class="img-float-right improve-your-trading-img">
    <div class="container w-container">
        <h2 class="improve-your-trading-title">
            {{ aiTrans(
                "Jak aplikacja [website_title] poprawia Twoje handel?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="improve-your-trading-text">
            {{ aiTrans(
                "Niezależnie od poziomu umiejętności, jaki posiadasz w handlu online, możesz skorzystać z potężnych funkcji handlowych oferowanych przez aplikację [website_title]. Przede wszystkim jednak musisz zrozumieć, jak działa oprogramowanie. [website_title] jest w stanie analizować rynki za pomocą wysoko rozwiniętego algorytmu, który wykorzystuje ogromne ilości danych rynkowych oraz kilka ważnych wskaźników technicznych, aby zidentyfikować ustawienia handlowe o wysokim prawdopodobieństwie. Będziesz mógł również dostosować parametry w intuicyjnym interfejsie oprogramowania. Wystarczy dostosować sposób, w jaki oprogramowanie działa, w zależności od Twojego poziomu umiejętności, tolerancji na ryzyko i preferencji. Oprogramowanie pozwala nawet początkującym traderom rozpocząć handel na rynkach bez obaw o popełnienie błędu przy analizie ruchów cen na rynkach i wiedzieć, kiedy wejść w transakcję. Dodatkowo, inną dużą funkcją jest to, że w miarę jak zaczynasz postępować jako trader, możesz chcieć przyjąć bardziej praktyczne podejście. W tej sytuacji oprogramowanie może nadal być bardzo pomocne w potwierdzeniu Twojej własnej analizy rynku przed wejściem w transakcję. Nawet na wyższym poziomie umiejętności, nadal możesz znaleźć się w sytuacjach, gdzie będziesz zbyt nerwowy lub podekscytowany, aby podejmować logiczne decyzje handlowe. W takim przypadku możesz skorzystać z analizy rynku dostarczonej przez aplikację. Pozwala to uniknąć błędu emocjonalnego w handlu, zapewniając, że wchodzisz w transakcje oparte na analizach rynku opartych na danych. Jedną z najlepszych rzeczy w [website_title] jest to, że rejestracja nowego konta jest całkowicie darmowa. Zarejestruj się teraz i zacznij handlować na rynkach.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans('Otwórz darmowe konto teraz')}}</a>
        </div>
        <div class="improve-your-trading-bg"></div>
    </div>
    <div class="improve-your-trading-bg-2"></div>
</div>
<div class="features wf-section">
    <div class="container w-container">
        <div class="features-bg"></div>
        <h2 class="features-title">
            {{ aiTrans(
                "Główne funkcje [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="features-text">
            {{ aiTrans(
                "[website_title] to najnowsza wersja naszej potężnej aplikacji handlowej, zaprojektowanej, aby pomóc inwestorom uzyskać dostęp i w pełni wykorzystać możliwości handlu kryptowalutami na rynkach. Nasze zaawansowane technologie finansowe łączą ponad 15 narzędzi analizy technicznej, aby pomóc traderom zidentyfikować idealne punkty wejścia i wyjścia cen przy handlu swoimi ulubionymi kryptowalutami online. Nowy [website_title] wspiera szerszą gamę kryptowalut, oferując więcej opcji, jeśli chodzi o handel. Niezależnie od tego, czy interesuje Cię Bitcoin, Ethereum czy inne popularne kryptowaluty, możesz je handlować w nowym [website_title].",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="features-list w-row">
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature1-icon.webp" alt="{{$website_title}} - Zaawansowane algorytmy handlowe" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Zaawansowane algorytmy handlowe')}}</h3>
                    </div>
                    <div class="features-list-item-text">{{aiTrans('Nasze algorytmy handlowe są bardziej zaawansowane niż kiedykolwiek, umożliwiając Ci wykorzystanie ruchów rynkowych w czasie rzeczywistym. Dzięki zaawansowanym algorytmom uczenia maszynowego, [website_title] może analizować dane rynkowe i przewidywać przyszłe ruchy cen, dając Ci przewagę w swoich transakcjach.', $locale , ['website_title' => $website_title])}}</div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature2-icon.webp" alt="{{$website_title}} - Ulepszony interfejs użytkownika" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Ulepszony interfejs użytkownika')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        
                        {{ aiTrans(
                            "Całkowicie przeprojektowaliśmy nasz interfejs użytkownika, czyniąc go bardziej intuicyjnym i łatwiejszym w użyciu. Niezależnie od tego, czy jesteś nowicjuszem, czy doświadczonym traderem, nowy [website_title] będzie łatwy do nawigacji i użytkowania.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature3-icon.webp" alt="{{$website_title}} - Ulepszona bezpieczeństwo" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Ulepszona bezpieczeństwo')}}</h3>
</div>
<div class="features-list-item-text">
    {{ aiTrans(
        "Bezpieczeństwo jest naszym głównym priorytetem w [website_title], a nowa platforma zawiera szereg zaawansowanych funkcji bezpieczeństwa, aby chronić Twoje fundusze i dane osobowe. Nasza platforma jest chroniona szyfrowaniem SSL i uwierzytelnianiem dwuetapowym, a także stosujemy najnowsze protokoły bezpieczeństwa, aby chronić Twoje dane.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</div>
</div>
</div>
</div>
<div class="button-wrapper margin-0-auto">
    <a href="#formTop" class="button w-button">{{aiTrans("ZAREJESTRUJ SIĘ TERAZ")}}</a>
</div>
</div>
<div class="featues-bg-1"></div>
</div>
<div class="steps wf-section">
    <div class="container w-container">
        <h2 class="steps-title">
            {{ aiTrans(
                "Jak zarejestrować się w [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="steps-list w-row">
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Krok pierwszy')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Rejestracja')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "Pierwszym krokiem jest wypełnienie formularza rejestracyjnego, który można znaleźć na naszej stronie internetowej. Będziesz poproszony o podanie podstawowych informacji, takich jak imię, nazwisko, adres e-mail i numer telefonu. Po otrzymaniu e-maila potwierdzającego i kliknięciu w link potwierdzający, zostaniesz zarejestrowany, a Twoje nowe konto zostanie aktywowane. Oznacza to, że będziesz mieć pełny dostęp do aplikacji handlowej [website_title].",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Krok drugi')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Finansowanie')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "Po aktywowaniu swojego nowego konta będziesz musiał wpłacić fundusze na swoje konto. Handel wymaga kapitału, aby utrzymać pozycje na rynku. Będziesz zobowiązany do zainwestowania minimalnej kwoty pieniędzy, aby dokonywać transakcji za pomocą aplikacji [website_title]. Im więcej zainwestujesz, tym większy potencjalny zysk możesz uzyskać. Jednak oznacza to również wyższe ryzyko straty. Początkujący powinni na początku inwestować tylko minimalną wymaganą kwotę depozytu. Pozwoli to na naukę podstaw handlu przed zainwestowaniem większych środków.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Krok trzeci')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Handel')}}</h3>
</div>
<div>{{aiTrans('Na koniec będziesz musiał dostosować parametry handlu w oprogramowaniu. Aplikacja może zostać spersonalizowana, aby dopasować się do Twojej tolerancji na ryzyko, preferencji i celów handlowych. Zapewni to najlepsze możliwe doświadczenie handlowe. Po zakończeniu konfiguracji parametrów handlowych, będziesz gotowy, aby rozpocząć handel z wykorzystaniem naszego potężnego algorytmu i analizy rynku.')}}</div>
</div>
</div>
</div>
<div class="button-wrapper steps-action-button">
    <a href="#formTop" class="button white w-button">{{aiTrans('Zarejestruj się teraz, aby zacząć')}}</a>
</div>
</div>
</div>
<div class="faq wf-section">
    <div class="container w-container">
        <h2 class="faq-title">{{aiTrans('Najczęściej zadawane pytania')}}</h2>
        <p class="faq-text">{{aiTrans('Prawdopodobnie nadal masz pewne wątpliwości dotyczące tego, jak działa nasze oprogramowanie handlowe. Jeśli jesteś początkującym traderem, prawdopodobnie będziesz miał również pytania, jak powinieneś zacząć. Oto niektóre z najczęściej zadawanych pytań, które otrzymujemy od traderów.')}}</p>
        <div class="faq-accordion">
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">1</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Czym jest nowa wersja [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Nowa wersja [website_title] to zaktualizowana wersja popularnej platformy handlu kryptowalutami, zaprojektowana, aby zapewnić traderom jeszcze bardziej potężne narzędzia i funkcje, które pomogą im osiągnąć sukces na rynku kryptowalut.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">2</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Jakie nowe funkcje oferuje nowa wersja [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Nowa wersja [website_title] oferuje szereg nowych funkcji, w tym zaawansowane narzędzia do zarządzania ryzykiem, dane rynkowe w czasie rzeczywistym, dostosowywalne wykresy i tabele oraz analizę wiadomości i wydarzeń.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">3</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Czy nowa wersja [website_title] jest bezpieczna w użyciu?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
<div class="faq-arrow">+</div>
</div>
<div class="faq-accordion-wrap">
    <p class="faq-answer">
        {{ aiTrans(
            "Tak, nowa wersja [website_title] jest bezpieczna w użyciu. Platforma stosuje zaawansowane środki bezpieczeństwa, aby chronić dane i transakcje użytkownika, a nasz zespół ekspertów monitoruje platformę 24 godziny na dobę, 7 dni w tygodniu, aby zapewnić, że jest ona bezpieczna i niezawodna.",
            $locale,
            ['website_title' => $website_title],
        ) }}
    </p>
</div>
</div>
<div class="faq-accordion-item">
    <div class="faq-accordion-title">
        <div class="faq-number">4</div>
        <h3 class="heading">
            {{ aiTrans(
                "Czy mogę dostosować moje doświadczenie handlowe w nowej wersji [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
        <div class="faq-arrow">+</div>
    </div>
    <div class="faq-accordion-wrap">
        <p class="faq-answer">
            {{ aiTrans(
                "Tak, nowa wersja [website_title] pozwala na personalizację doświadczenia handlowego, w tym dostosowywanie tabel i wykresów, które umożliwiają łatwe przeglądanie danych rynkowych i trendów.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
    </div>
</div>
<div class="faq-accordion-item">
    <div class="faq-accordion-title">
        <div class="faq-number">5</div>
        <h3 class="heading">
            {{ aiTrans(
                "Czy nowa wersja [website_title] jest odpowiednia dla początkujących?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
        <div class="faq-arrow">+</div>
    </div>
    <div class="faq-accordion-wrap">
        <p class="faq-answer">
            {{ aiTrans(
                "Tak, nowa wersja [website_title] jest odpowiednia dla początkujących. Platforma jest przyjazna dla użytkownika i łatwa w nawigacji, a nasz zespół ekspertów jest dostępny, aby udzielać wskazówek i wsparcia dla traderów na każdym poziomie doświadczenia.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
    </div>
</div>
</div>
<div class="button-wrapper">
    <a href="#formTop" class="button w-button">{{aiTrans("ZAREJESTRUJ SIĘ TERAZ")}}!</a>
</div>
</div>
<div class="faq-bg-2"></div>
<div class="faq-bg-3"></div>
</div>
<div class="highlights-section wf-section">
    <div class="container w-container">
        <h2 class="faq-title">
            {{ aiTrans(
                "[website_title] Najważniejsze informacje",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
<div class="high-table">
    <div class="tr">
        <div class="td w-clearfix">
            <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-1.webp" alt="Najważniejsze informacje" class="high-img">
            <div class="high-text">{{aiTrans('Typ')}}</div>
        </div>
        <div class="td">
            <div class="high-text">{{aiTrans('Robot handlowy AI')}}</div>
        </div>
    </div>
    <div class="tr">
        <div class="td w-clearfix">
            <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Najważniejsze informacje" class="high-img">
            <div class="high-text">{{aiTrans('Koszt aplikacji')}}</div>
        </div>
        <div class="td">
            <div class="high-text">{{aiTrans('Darmowy')}}</div>
        </div>
    </div>
    <div class="tr">
        <div class="td w-clearfix">
            <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-3.webp" alt="Najważniejsze informacje" class="high-img">
            <div class="high-text">Opłaty</div>
        </div>
        <div class="td">
            <div class="high-text">{{aiTrans('Brak')}}</div>
        </div>
    </div>
    <div class="tr">
        <div class="td w-clearfix">
            <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-4.webp" alt="Najważniejsze informacje" class="high-img">
            <div class="high-text">{{aiTrans('Konto demo')}}</div>
        </div>
        <div class="td">
            <div class="high-text">{{aiTrans('Tak')}}</div>
        </div>
    </div>
    <div class="tr">
        <div class="td w-clearfix">
            <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Najważniejsze informacje" class="high-img">
            <div class="high-text">{{aiTrans('Aktywa')}}</div>
        </div>
        <div class="td">
            <div class="high-text">{{aiTrans('BTC, ETH, XRP, DASH i inne')}}</div>
        </div>
    </div>
    <div class="tr">
        <div class="td w-clearfix">
            <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-6.webp" alt="Najważniejsze informacje" class="high-img">
            <div class="high-text">{{aiTrans('Ochrona danych użytkownika')}}</div>
        </div>
        <div class="td">
            <div class="high-text">{{aiTrans('Tak')}}</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
