@extends('layouts.app')
@section('title', $website_title .' | Şartlar ve Koşullar')
@php( $meta_description = "Şartlar ve Koşullarımızı okuyun. Şartlarımız, haklarınızı, sorumluluklarınızı ve hizmetlerimizi güvenli ve etkili bir şekilde nasıl kullanacağınızı açıklar.")

@section('content')
<div class="terms-and-conditions wf-section">
        <div class="w-container">
            <h1>ŞARTLAR VE KOŞULLAR</h1>
            <div>
                <style>
                    table {
                        width: 100%;
                    }
    
                    table,
                    th,
                    td {
                        border: 1px solid;
                        border-collapse: collapse;
                    }
    
                    th,
                    td {
                        padding: 10px;
                    }
    
                    table td {
                        vertical-align: top;
                    }
    
                    .nested-list {
                        counter-reset: item;
                    }
    
                    .nested-list li {
                        display: block;
                    }
    
                    .nested-list li:before {
                        content: counters(item, '.') '. ';
                        counter-increment: item;
                    }
    
                    .legal-section {
                        text-align: left;
                    }
    
                    .legal-section h3 {
                        margin-top: 30px;
                        font-size: 24px;
                    }
    
                    .legal-section h4 {
                        font-size: 18px;
                    }
                </style>
                <p>
                    {{aiTrans('Web sitemizi ziyaret ettiğiniz için teşekkür ederiz')}} <a href="{{ route('home', $country) }}"> {{ aiTrans('web sitesi', $locale) }}</a> {{aiTrans('(“Web Sitesi”) ve bu Şartlar ve Koşulların (bu “Web Sitesi”) ve bizim')}} <a href="{{ route('privacy', $country) }}">{{aiTrans('Gizlilik Politikamız', $locale) }}</a> {{aiTrans('(“Gizlilik Politikası”) bağlantısını bulduğunuz yer. Bu web sitesi,')}} {{ $website_title }}{{aiTrans(' ve bizimle ilişkili olan her türlü ana şirket, yan kuruluş veya bağlı kuruluş tarafından işletilmekte ve kontrol edilmektedir. Web Sitesi bizim mülkümüzdür (toplu olarak “biz,” “bizim” veya “bizimkiler” olarak anılacaktır) ve bizimle iletişime geçebilirsiniz')}}
                    {{ aiTrans('her zaman e-posta yoluyla: ', $locale) }} <span >info{{ '@'.$website_title }}</span>
                </p>
                <p>
                    {{ aiTrans('Web Sitesine erişerek veya ürünlerimizi ve/veya hizmetlerimizi kullanarak ("Sağlayıcı Hizmetleri" ve Abonelik Hizmetleri ile topluca "Hizmetler"), bu Şartlar ("Şartlar") ve Gizlilik Politikamızı kabul ettiğinizi beyan ediyorsunuz. Bu Şartlar, operasyonel kurallar, politikalar, bilgiler ve diğer ek şartları içerir. Şartları zaman zaman, önceden bildirimde bulunmaksızın ve bizim takdirimize bağlı olarak değiştirme hakkını saklı tutarız. Şartlardaki güncellemeleri periyodik olarak gözden geçirmeniz sizin sorumluluğunuzdadır, çünkü yayımlandıktan sonra geçerli olacaktır. Web Sitesinin sürekli kullanımı, Şartların kabulü olarak kabul edilecektir.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Lütfen bu Şartlar ve Koşulların tamamını dikkatlice gözden geçirin. Bunların herhangi bir kısmına itiraz ediyorsanız, Hizmetleri veya Web Sitesini hiçbir şekilde kullanmanıza izin verilmez. Web Sitesine ve/veya Hizmetlere erişimi bizim takdirimize bağlı olarak reddetme hakkını saklı tutarız.', $locale) }}
                </p>
                <h3>{{ aiTrans('YATIRIM DANIŞMANLIĞI YOKTUR', $locale) }}</h3>
<p>
    {{ aiTrans('Aksi belirtilmedikçe, bu web sitesi, kişisel finansal veya yatırım danışmanlığı sağlamak amacıyla tasarlanmamıştır. Sağlanan bilgiler, sizin özel yatırım hedeflerinizi, mali durumunuzu veya yatırım ihtiyaçlarınızı dikkate almaz.', $locale) }}
</p>
<p>
    {{ aiTrans('Bu web sitesindeki bilgilerin, yatırım hedeflerinize, mali durumunuza ve yatırım ihtiyaçlarınıza uygun olup olmadığını değerlendirmeniz gerekir. Bu değerlendirmeyi, verilen bilgilerle yatırım kararı almadan önce kendiniz yapmalı veya bağımsız bir finansal danışmandan profesyonel yardım almayı düşünebilirsiniz.', $locale) }}
</p>
<p>
    {{ aiTrans('Aksi belirtilmedikçe, bu web sitesindeki bilgiler, IG grup şirketlerinden herhangi biri tarafından sunulan herhangi bir finansal ürün veya hizmeti yatırım tavsiyesi olarak değerlendirilmemelidir.', $locale) }}
</p>
<h3>{{ aiTrans('ÜRÜNLER VE HİZMETLER', $locale) }}</h3>
<p>
    {{ aiTrans('Bu web sitesinde belirtilen tüm ürünler ve hizmetler, bizim tarafımızdan sağlanıyor olmayabilir. Üçüncü tarafların herhangi bir ürün, hizmet, web sitesi veya ağlarını tanımlamak veya kullanmak, bu ürünleri, hizmetleri, web sitelerini veya ağları tavsiye ettiğimiz anlamına gelmez. Bu web sitesi, bizim dışımızdaki kişilerin sağladığı web sitelerine ve ağlara, hiperlink veya başka bir bağlantı aracılığıyla erişim sağlamanıza olanak tanıyabilir.', $locale) }}
</p>
<p>
    {{ aiTrans('Herhangi bir üçüncü taraf web sitesi veya ağındaki materyallerle ilgili olarak herhangi bir sorumluluk veya yükümlülük kabul etmiyoruz. Bu bağlantı üzerinden başka web sitelerine veya ağlara erişiminiz, o web sitesi veya ağ sahibine sizinle ilgili belirli bilgileri vermemizi gerektirebilir. Bu web sitesindeki hiçbir şey, bizim veya bizim tarafımızdan yatırım danışmanlığı olarak anlaşılmamalıdır.', $locale) }}
</p>
<h3>{{ aiTrans('KAPSAM VE DEĞİŞİKLİK', $locale) }}</h3>
<p>
    {{ aiTrans('Bu belgedeki şartlarla, web sitemizi kullanmaya ilişkin kabul ettiğinizi beyan ediyorsunuz. Bu Şartlar, sizinle bizim aramızdaki tüm anlaşmayı oluşturur ve daha önceki tüm anlaşmalar, beyanlar, garantiler ve anlayışları geçersiz kılar.', $locale) }}
</p>
<p>
    {{ aiTrans('Lütfen bu Şartların zaman zaman değişebileceğini unutmayın. Bu Şartları değiştirdiğimizde, değişiklikler hakkında sizi bilgilendireceğiz. Ayrıca, yapılan değişiklikleri gösteren bir bildirim yayınlayacağız. Web Sitesinin ve/veya Hizmetlerimizin sürekli kullanımı, geçerli olan güncellenmiş şartları kabul ettiğiniz anlamına gelir. Bu sayfayı düzenli olarak kontrol etmek, güncellemeler ve/veya değişiklikler için sizin sorumluluğunuzdadır.', $locale) }}
</p>
<h3>{{ aiTrans('GEREKSİNİMLER', $locale) }}</h3>
<p>
    {{ aiTrans('Web Sitesi ve Hizmetlerimiz, yalnızca geçerli yasalarla bağlayıcı sözleşmeler imzalayabilecek nitelikli bireyler için mevcuttur. 18 yaşından küçük bireyler için kullanıma sunulmamıştır. Eğer 18 yaşından küçük iseniz, Web Sitesini ve/veya Hizmetleri kullanmak ve/veya erişmek için izniniz yoktur.', $locale) }}
</p>
<h3>{{ aiTrans('HİZMETLERİN AÇIKLAMASI', $locale) }}</h3>
<p>
    <i>{{ aiTrans('Abonelik Hizmetleri:', $locale) }}</i> {{ aiTrans('Web Sitesine kaydolarak ve bizim onayımızı alarak, ücretli veya ücretsiz olarak Abonelik Hizmetleri alabilirsiniz. Bu hizmetler, e-posta, metin ve diğer materyallerden oluşan ("Abonelik İçeriği") çevrimiçi pazarlama içerikleri sunar, ancak bu bir yatırım danışmanlığı değildir. Abonelik İçeriği’nin doğruluğundan, tamamlanmasından veya uygunluğundan sorumlu olmadığımızı kabul ediyorsunuz.', $locale) }}
</p>
<p>
    <i>{{ aiTrans('Sağlayıcı ve Üçüncü Taraf Hizmetleri:', $locale) }}</i> {{ aiTrans('Kayıt formlarını doldurarak, Web Sitesinden belirli ürün ve/veya hizmetler alabilirsiniz. Ürün ve/veya hizmet açıklamaları, Üçüncü Taraf Sağlayıcılar tarafından sağlanabilir. Bu açıklamaların doğruluğu veya tamamlanabilirliği konusunda herhangi bir garanti vermiyoruz. Web Sitesinden ürün ve/veya hizmet alamamanız veya bağlı ortaklarla herhangi bir anlaşmazlık durumunda sorumlu olmadığımızı kabul ediyorsunuz.', $locale) }}
</p>
<p>
    <i>{{ aiTrans('Genel:', $locale) }}</i> {{ aiTrans('Hizmetleri kullanabilmek için doğru Hizmet Kayıt verilerini sağlamalısınız, ve eksik, sahte veya kabul edilemez verileri reddetme hakkımızı saklı tutarız. Aksi belirtilmedikçe, Web Sitesinin gelecekteki herhangi bir teklifi, bu Şartlara tabidir. Hizmetleri kullanamamanız veya bu Hizmetlere uygun olamamanızdan ve herhangi bir değişiklik, askıya alma veya iptal durumunda sorumlu olmadığımızı kabul ediyorsunuz.', $locale) }}
</p>
<h3>{{ aiTrans('MALİKİYET HAKLARI', $locale) }}</h3>
<p>
    {{ aiTrans('Web Sitesi, İçerik ve Hizmetler, organizasyon, grafikler, tasarım, derleme, yazılım ve diğer konular dahil olmak üzere, geçerli telif hakları, ticari markalar ve diğer sahiplik hakları ile korunmaktadır. Web Sitesinin, İçeriğin ve/veya Hizmetlerin herhangi bir kısmının çoğaltılması, yeniden dağıtılması veya satılması kesinlikle yasaktır. Otomatik araçlarla veya veri çekme yöntemleriyle malzeme toplamak için yazılı izin alınmadan kullanım yasaktır. Web Sitesindeki içerik, belge, yazılım, hizmetler veya materyaller üzerinde mülkiyet hakları edinmezsiniz. Bizim adımız, logomuz, grafiklerimiz, simgelerimiz ve hizmet isimlerimiz ticari markalardır. Ticari markaların izinsiz kullanımı kesinlikle yasaktır.', $locale) }}
</p>
<h3>{{ aiTrans('GİZLİ BİLGİLER', $locale) }}</h3>
<p>
    {{ aiTrans('Gizli bilgiler, bu şekilde tanımlanmış olan ve halka açık olmayan, önceden var olan bilgi, bağımsız olarak geliştirilen bilgiler veya üçüncü taraflardan açıklama kısıtlaması olmadan alınan bilgiler hariç olmak üzere, mülkiyet bilgilerine atıfta bulunur. Gizli bilgileri koruma yükümlülüğü, söz konusu ilişkinin sona ermesinden bir (1) yıl sonra sona erer.', $locale) }}
</p>
<h3>{{ aiTrans('WEB SİTESİNE HİPERLİNK YAPMA, CO-BRANDING, "FRAMING" VE/VEYA WEB SİTESİNE ATIF', $locale) }}</h3>
<p>
    {{ aiTrans('Web Sitesine veya onun herhangi bir kısmına başka bir web sitesinde hiperlink yapmak, açık onayımız olmadan yasaktır. Web Sitesini "Framing" yapmak veya Uniform Resource Locator ("URL")’yi iznimiz olmadan referans göstermek kesinlikle yasaktır. Bu tür içerik veya faaliyetlerin kaldırılması için işbirliği yapmak zorunludur ve bununla ilişkili herhangi bir zarardan siz sorumlusunuz.', $locale) }}
</p>
<h3>{{ aiTrans('DÜZENLEME, SİLME VE DEĞİŞİKLİK', $locale) }}</h3>
<p>
    {{ aiTrans('Web Sitesindeki herhangi bir belgeyi, bilgiyi veya içeriği önceden bildirimde bulunmaksızın düzenleme ve/veya silme hakkını saklı tutuyoruz.', $locale) }}
</p>
<h3>{{ aiTrans('SORUMLULUK REDDİ', $locale) }}</h3>
<p>
    {{ aiTrans('WEB SİTESİ, HİZMETLER, İÇERİK VE ÜÇÜNCÜ TARAF ÜRÜNLERİ "OLDUĞU GİBİ" VE "MEVCUT OLDUĞU ŞEKİLDE" SUNULMAKTADIR, HER TÜRLÜ AÇIK VE ZIMNİ GARANTİ HARİÇTİR VE GEÇERLİ YASA ÇERÇEVESİNDE MÜMKÜN OLAN EN GENİŞ ŞEKİLDE REDDEDİLMİŞTİR. WEB SİTESİ, HİZMETLER, İÇERİK VE/VEYA ÜÇÜNCÜ TARAF ÜRÜNLERİNİN İHTİYAÇLARINIZI KARŞILAYACAĞINI VEYA KESİNTİSİZ, ZAMANINDA, GÜVENLİ VE HATASIZ OLACAĞINI GARANTİ ETMİYORUZ. WEB SİTESİNİ, HİZMETLERİ, İÇERİĞİ VE/VEYA ÜÇÜNCÜ TARAF ÜRÜNLERİNİ KULLANAMAMANIZLA İLGİLİ HİÇBİR İDDİA KONUSUNDA SORUMLU OLMADIĞIMIZI KABUL EDERSİNİZ. WEB SİTESİ HATA, KUSUR VEYA SINIRLAMALAR İÇEREBİLİR, VE İNTERNET BAĞLANTISININ MEVCUTLUĞU KONUSUNDA SORUMLU DEĞİLİZ.', $locale) }}
</p>
<h3>{{ aiTrans('SORUMLULUK SINIRLAMASI', $locale) }}</h3>
<p>
    {{ aiTrans('DOĞRUDAN, DOLAYLI, DARBANCI, ÖZEL VEYA CEZAİ ZARARLAR, KAR KAYBI, İYİWILL, KULLANIM, VERİLER VEYA DİĞER SOFT İNTANGİBİLİTE KAYIPLARI İÇİN SORUMLU DEĞİLİZ. BU SINIRLAMA, HER TÜRLÜ İŞLEMİ KAPSAR, SÖZLEŞME İHLALİ, GARANTİ, İHMAL, ZORUNLU SORUMLULUK, YANILTICI AÇIKLAMALAR VE DİĞER HERHANGİ BİR HUKUKİ İHLALİ. BİZİ VE ÜÇÜNCÜ SAĞLAYICILARIMIZI, BELİRTİLEN SINIRLAMANIN DIŞINDA HERHANGİ BİR YÜKÜMLÜLÜK, SORUMLULUK VE İDDİALARDAN MUAF TUTARSINIZ. GEÇERLİ YASA, BU SINIRLAMAYI KABUL ETMEYİ SAĞLAMAZSA, HERHANGİ BİR DURUMDA SORUMLULUĞUMUZUN MAKSİMUM SINIRI BEŞ YÜZ DOLAR ($500,00) OLACAKTIR.', $locale) }}
</p>
<h3>{{ aiTrans('TAZMİNAT', $locale) }}</h3>
<p>
    {{ aiTrans('Web Sitesini, Hizmetleri veya İçeriği kullanmanızdan dolayı, herhangi bir üçüncü tarafın iddialarından, masraflarından, zararlarından, davalarından, maliyetlerinden, taleplerinden ve/veya mahkemelerden bizi, ortaklarımızı, yan kuruluşlarımızı, bağlı kuruluşlarımızı ve ilgili üyelerimizi, yöneticilerimizi, çalışanlarımızı, ajanlarımızı ve ortaklarımızı tazmin etmeyi ve onlara zarar vermemeyi kabul ediyorsunuz.', $locale) }}
</p>
<h3>{{ aiTrans('ÜÇÜNCÜ TARAF WEB SİTELERİ', $locale) }}</h3>
<p>
    {{ aiTrans('Web Sitesi, Üçüncü Taraf Sağlayıcılarına ait diğer web sitelerine ve/veya kaynaklara bağlantılar sağlayabilir. Bu üçüncü tarafların web sitelerinin ve/veya kaynaklarının mevcutluğundan ve içeriklerinden sorumlu değiliz, ve bu sitelerin, içeriklerinin, reklamlarının, hizmetlerinin, ürünlerinin veya materyallerinin şartlarını, gizlilik politikalarını, içeriğini, hizmetlerini, ürünlerini veya materyallerini onaylamıyoruz veya sorumluluk taşımıyoruz.', $locale) }}
</p>
<h3>{{ aiTrans('GİZLİLİK POLİTİKASI/ ZİYARETÇİ BİLGİLERİ', $locale) }}</h3>
<p>
    {{ aiTrans('Web Sitesini kullanmanız ve tüm yorumlarınız, geri bildirimleriniz, kayıt bilgileriniz ve/veya gönderdiğiniz materyaller, Gizlilik Politikamıza tabidir. Web Sitesini kullanımınızla ilgili bilgileri ve kişisel olarak tanımlanabilir bilgileri, Gizlilik Politikamıza ve geçerli veri koruma yasalarına uygun olarak kullanma hakkını saklı tutuyoruz.', $locale) }}
</p>
<h3>{{ aiTrans('HUKUKİ UYARI', $locale) }}</h3>
<p>
    {{ aiTrans('Web Sitesinin işleyişine zarar vermek, yok etmek, tahrif etmek, vandalizm yapmak veya müdahale etmek, ceza kanunu ve medeni hukuka aykırıdır. Yasalar ve adalet çerçevesinde, her türlü suçluya karşı kaynak arayacağız.', $locale) }}
</p>
<h3>{{ aiTrans('HUKUK SEÇİMİ VE YARGI YERİ', $locale) }}</h3>
<p>
    {{ aiTrans('Bu Şartlar, Birleşik Krallık yasalarına tabidir ve onların hükümleri ile yorumlanacaktır. Taraflar, bu Şartlar ve Koşullar ile ilgili her türlü iddia veya anlaşmazlık için iyi niyetle müzakere etmeye çalışacaktır. Eğer taraflar arasında anlaşmazlık çıkarsa, dava yalnızca Londra\'da bir tek hakem önünde gizli tahkim prosedürlerine tabi olacaktır, ICC kuralları altında, ve karar bağlayıcı olacaktır. Taraflardan hiçbiri, kendi ikametgahının yerel mahkemelerine veya başka bir yargı yerinde dava açmamalıdır.', $locale) }}
</p>
<h3>{{ aiTrans('VERİ KORUMA EKİ', $locale) }}</h3>
<p>
    {{ aiTrans('Bu Veri Koruma Ekini, Şartlar ve Koşullarımızın bir parçası olarak kabul edersiniz. Burada kullanılan terimler, bu Ek’te belirtilen anlamlara sahiptir. Aşağıda değiştirilmediği sürece, Şartlar tam olarak geçerli olmaya devam eder.', $locale) }}
</p>
<ol class="nested-list">
    <li>
        <b>{{ aiTrans('Tanımlar', $locale) }}</b>
        <ol class="nested-list">
            <li>
                <b>{{ aiTrans('Uygulanan Yasalar:', $locale) }}</b> {{ aiTrans('AB Veri Koruma Yasaları ve diğer geçerli Veri Koruma Yasalarına tabi olan Kişisel Verilerle ilgili AB veya Üye Devlet Yasaları.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Veri Sorumlusu:', $locale) }}</b> {{ aiTrans('Kişisel Verilerin işlenmesinin amaçlarını ve araçlarını belirleyen kuruluş.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Veri Koruma Yasaları:', $locale) }}</b> {{ aiTrans('AB Veri Koruma Yasaları ve diğer herhangi bir ülkenin veri koruma veya gizlilik yasaları.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('AB Veri Koruma Yasaları:', $locale) }}</b> {{ aiTrans('AB Direktifi 95/46/EC, GDPR ve ilgili yasalar.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('GDPR:', $locale) }}</b> {{ aiTrans('AB Genel Veri Koruma Yönetmeliği 2016/679.', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('Kişisel Veri Toplama ve İşleme', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('Kişisel Verilerin İşlenmesinde geçerli olan tüm Veri Koruma Yasalarına uymayı kabul ediyoruz.', $locale) }}
                <ol class="nested-list">
                    <li>
                        {{ aiTrans('Veri sahiplerinden, Kişisel Verilerin yasal olarak toplanması, işlenmesi ve paylaşılması için gerekli izinleri ve onayları aldığımızı beyan ve garanti ederiz.', $locale) }}
                    </li>
                    <li>
                        {{ aiTrans('Geçerli Yasalarla uyumlu olarak, onay almak ve geri almak için bir mekanizma ve herkese açık bir gizlilik politikası sağlayacağız.', $locale) }}
                    </li>
                    <li>
                        {{ aiTrans('On sekiz (18) yaşından küçük çocuklara hizmet vermediğimizi kabul ederiz.', $locale) }}
                    </li>
                </ol>
            </li>
        </ol>
    </li>
<li>
    <b>{{ aiTrans('Güvenlik', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('GDPR Madde 32(1) ile uyumlu olarak, verilerin güvenliği için uygun teknik ve organizasyonel önlemler alacağız.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Alt İşlemci Kullanımı', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Bize Alt İşlemciler atama yetkisi veriyorsunuz ve Alt İşlemcilerle yapılan yazılı sözleşmelerin, bu Ek’te açıklanan Kişisel Veriler için aynı koruma seviyesini sağladığından ve GDPR gereksinimlerini karşıladığından emin olacağız.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Veri Sahiplerinin Hakları', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Veri Sahiplerinin Haklarına ilişkin taleplere, işleme niteliği göz önünde bulundurularak, Veri Koruma Yasaları ile uyumlu şekilde yanıt vermeye yardımcı olacağız.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Kişisel Veri İhlali', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Kişisel Veri İhlali hakkında bilgi edinir edinmez, etkilenen Veri Sahiplerini derhal bilgilendirecek ve soruşturma, hafifletme ve düzeltme konusunda yardımcı olacağız.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Genel Şartlar', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Bu Şartlardan kaynaklanan herhangi bir anlaşmazlık veya şikayet, burada belirtilen yargı yetkisine tabidir. Herhangi bir hüküm geçersiz sayılırsa, geri kalan hükümler geçerli kalacaktır.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Değişiklikler', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Bu Şartlarda zaman zaman tamamen kendi takdirimize bağlı olarak değişiklikler yapılabilir.', $locale) }}
        </li>
    </ol>
</li>
</ol>
<p>
    {{aiTrans('Bu Şartlar ve Koşullar ile kabul ederek, yukarıda açıklanan tüm şartları okuduğunuzu, anladığınızı ve bağlı kalmayı kabul ettiğinizi beyan ediyorsunuz. Web Sitesi ve Hizmetleri sürekli kullanmanız, bu şartların kabulü anlamına gelir. Herhangi bir sorunuz veya endişeniz varsa, bizimle şu e-posta adresinden iletişime geçebilirsiniz:')}} <span >info{{ '@'.$website_title }}</span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>


            </div>
        </div>
    </div>
@endsection
