<?php

use App\Support\Dashboard\ChangeLocalizationAction;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'dashboard', 'as' => 'dashboard.', 'middleware' => ['LocalizationDashboard','loginWithToken']], function () {
    require __DIR__ . '/auth.routes.php';
    Route::group(['prefix' => 'core', 'as' => 'core.', 'namespace' => 'App\\Http\\Controllers\\Dashboard\\Core'], function () {
//        Route::post('select-model-ajax', 'GeneralController@ModelSelectAjax')
//            ->name('select-model-ajax');
//        Route::post('select-model-ajax/{id}', 'GeneralController@SelectedModel')
//            ->name('selected-model-ajax');
    });
    Route::group(['middleware' => 'auth'], static function () {
        Route::group(['namespace' => 'App\\Http\\Controllers\\Dashboard'], static function () {

            Route::get('/', [App\Http\Controllers\Dashboard\Core\HomeController::class, 'superAdminDashboard'])->name('home');

            Route::get('change-language/{locale}', [ChangeLocalizationAction::class, '__invoke'])
                ->name('change-language');
            require __DIR__ . '/core.routes.php';
            require __DIR__ . '/link.routes.php';
            require __DIR__ . '/user.routes.php';
            require __DIR__ . '/blog.routes.php';

        });

    });

});
