<?php $__env->startSection('title', $website_title .' | Zásady ochrany osobních údajů'); ?>
<?php ( $meta_description = "Zjistěte, jak ". $website_title." chrání vaše osobní údaje. Naše zásady ochrany osobních údajů podrobně popisují opatření, která přijímáme k zajištění bezpečnosti a transparentnosti vašich informací."); ?>

<?php $__env->startSection('content'); ?>
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>ZÁSADY OCHRANY OSOBNÍCH ÚDAJŮ</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3><?php echo e(aiTrans('1. Úvod', $locale)); ?></h3>
            <p>
                <?php echo e(aiTrans('Toto prohlášení popisuje zásady ochrany osobních údajů přijaté společností', $locale)); ?> <?php echo e($website_title); ?> ("<?php echo e(aiTrans('my', $locale)); ?>," "<?php echo e(aiTrans('náš', $locale)); ?>," "<?php echo e(aiTrans('nebo', $locale)); ?>")
                <?php echo e(aiTrans('vztahující se k našim produktům a službám ("Služby") a', $locale)); ?> <a href="<?php echo e(route('home',$country)); ?>"><?php echo e(aiTrans('webu', $locale)); ?></a>
                <?php echo e(aiTrans('("Web")', $locale)); ?>. <?php echo e(aiTrans('Ochrana vašeho soukromí a důvěrnosti vašich informací je pro nás zásadní při poskytování našich Služeb a provozování Webu.', $locale)); ?>

            </p>
            <p>
                <?php echo e(aiTrans('Naše Služby a Web mohou obsahovat odkazy na weby a služby třetích stran. Nejsme odpovědní za zásady ochrany osobních údajů těchto subjektů. Doporučujeme vám, abyste si před jejich použitím přečetli jejich zásady ochrany osobních údajů.', $locale)); ?>

            </p>

            <h3><?php echo e(aiTrans('2. Web; Návštěvníci a Uživatelé', $locale)); ?></h3>
            <h4><?php echo e(aiTrans('2.1. Obecné', $locale)); ?></h4>
            <p>
                <?php echo e(aiTrans('Tato část stanoví specifika sběru údajů od různých skupin: návštěvníků webu ("Návštěvníci"), uživatelů ("Uživatelé") a obchodních partnerů (souhrnně "Partneři"). Osobní údaje zahrnují IP adresu, jméno, kontaktní údaje a informace o našem vztahu.', $locale)); ?>

            </p>

            <h4><?php echo e(aiTrans('2.2. Sbírání a využití', $locale)); ?></h4>
            <p>
                <?php echo e(aiTrans('Při návštěvě Webu souhlasíte se sběrem a využitím vašich Osobních údajů. Pokud s těmito podmínkami nesouhlasíte, neměli byste Web navštěvovat. Můžeme shromažďovat informace prostřednictvím sledování zobrazení stránek, IP adres a cookies. Kromě toho zpracováváme údaje poskytnuté dobrovolně v rámci formulářů a registrací.', $locale)); ?>

            </p>

            <h4><?php echo e(aiTrans('2.3. Účel zpracování osobních údajů', $locale)); ?></h4>
            <p>
                <?php echo e(aiTrans('Zpracováváme Osobní údaje za účelem vylepšení, pochopení a personalizace našeho Webu a Služeb. To zahrnuje zlepšení přesnosti, komunikaci o Službách, podporu, plnění smluvních povinností a spolupráci s partnery. Ke každému zpracování je nutný souhlas nebo právní základ.', $locale)); ?>

            </p>

            <p><?php echo e(aiTrans('Následující tabulka popisuje účely a právní základ pro zpracování Osobních údajů:', $locale)); ?></p>
            <table>
                <tbody>
                    <tr>
                        <td><?php echo e(aiTrans('Registrace jako držitel účtu', $locale)); ?></td>
                        <td><?php echo e(aiTrans('Váš souhlas; Poskytování služeb nebo plnění smluvních povinností', $locale)); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(aiTrans('Poskytování a využití služeb', $locale)); ?></td>
                        <td><?php echo e(aiTrans('Plnění smluvních povinností', $locale)); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(aiTrans('Aktualizace provozu', $locale)); ?></td>
                        <td><?php echo e(aiTrans('Plnění smluvních povinností', $locale)); ?></td>
                    </tr>
                    <tr>
                        <td><?php echo e(aiTrans('Reakce na dotazy a poskytování podpory', $locale)); ?></td>
                        <td><?php echo e(aiTrans('Oprávněný zájem nebo plnění smluvních povinností', $locale)); ?></td>
                    </tr>
                </tbody>
            </table>

            <h3><?php echo e(aiTrans('3. Bezpečnost', $locale)); ?></h3>
            <p>
                <?php echo e(aiTrans('Používáme administrativní, organizační a technická opatření k ochraně Osobních údajů před neoprávněným přístupem, zveřejněním, změnou, ztrátou, zneužitím nebo poškozením.', $locale)); ?>

            </p>

            <h3><?php echo e(aiTrans('4. Přijetí těchto zásad', $locale)); ?></h3>
            <p>
                <?php echo e(aiTrans('Používáním Webu a/nebo Služeb návštěvníci, uživatelé a/nebo partneři potvrzují, že si přečetli a souhlasí s těmito zásadami. Jakékoli nesouhlasy znamenají, že byste neměli platformu používat.', $locale)); ?>

            </p>

            <h3><?php echo e(aiTrans('5. Kontakt na pověřence pro ochranu údajů', $locale)); ?></h3>
            <p>
                Pro otázky týkající se ochrany soukromí a údajů kontaktujte našeho "Pověřence pro ochranu údajů" na e-mailové adrese <span >info<?php echo e('@'.$website_title); ?></span>
            </p>








        <tr>
            <td><?php echo e(aiTrans('Poskytování a používání služeb', $locale)); ?></td>
            <td><?php echo e(aiTrans('Plnění služeb nebo smluvních povinností', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Provozní aktualizace', $locale)); ?></td>
            <td><?php echo e(aiTrans('Plnění služeb nebo smluvních povinností', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Odpovídání na dotazy a poskytování podpory', $locale)); ?></td>
            <td><?php echo e(aiTrans('Oprávněné zájmy nebo plnění služeb', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Služby, reklama a marketing na míru', $locale)); ?></td>
            <td><?php echo e(aiTrans('Oprávněné zájmy nebo váš souhlas', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Vylepšení a nabídka nových služeb', $locale)); ?></td>
            <td><?php echo e(aiTrans('Souhlas a oprávněné zájmy', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Odesílání reklamních a marketingových materiálů', $locale)); ?></td>
            <td><?php echo e(aiTrans('Váš souhlas', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Analýza účinnosti marketingových kampaní', $locale)); ?></td>
            <td><?php echo e(aiTrans('Oprávněné zájmy nebo souhlas', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Provádění různých podpůrných činností', $locale)); ?></td>
            <td><?php echo e(aiTrans('Oprávněné zájmy nebo plnění služeb', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Analýza, včetně statistické analýzy', $locale)); ?></td>
            <td><?php echo e(aiTrans('Oprávněné zájmy', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Ochrana zájmů, práv a majetku', $locale)); ?></td>
            <td><?php echo e(aiTrans('Oprávněné zájmy nebo právní povinnosti', $locale)); ?></td>
        </tr>
    </tbody>
</table>
<h4><?php echo e(aiTrans('2.4. Sdílení osobních údajů', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Můžeme sdílet informace s poskytovateli služeb, partnery a dodavateli. Pro návštěvníky a uživatele v evropské datové oblasti je zpracování dat v souladu s GDPR a platnými zákony o ochraně osobních údajů.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('3. Partneři', $locale)); ?></h3>
<h4><?php echo e(aiTrans('3.1. Obecné', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Za účelem poskytování služeb a spolupráce s partnery shromažďujeme a zpracováváme specifické typy dat. Partneři jsou odpovědní za své údaje a můžeme k nim přistupovat bezpečnými prostředky.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('3.2. Zpracování osobních údajů', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Spoléháme se na souhlas partnerů nebo oprávněné zájmy při zpracování osobních údajů. Mohou být vytvářeny agregované údaje pro rozvoj a zlepšení kvality.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('3.3. Správce/Zpracovatel', $locale)); ?></h4>
<p><?php echo e(aiTrans('Můžeme jednat jako správce nebo zpracovatel, v závislosti na typu dat:', $locale)); ?></p>
<ul>
    <li><?php echo e(aiTrans('Údaje návštěvníka/uživatele: Správce', $locale)); ?></li>
    <li><?php echo e(aiTrans('Údaje partnera: Zpracovatel', $locale)); ?></li>
    <li><?php echo e(aiTrans('Všechny údaje jsou bezpečně uloženy podle nejvyšších bezpečnostních standardů. Implementujeme fyzická, technická a organizační opatření.', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('3.4. Ochrana údajů třetích stran', $locale)); ?></h4>
<p><?php echo e(aiTrans('Pokud služby zahrnují zpracování osobních údajů na platformě třetí strany:', $locale)); ?></p>
<ul>
    <li><?php echo e(aiTrans('Jednáme jako zpracovatel', $locale)); ?></li>
    <li><?php echo e(aiTrans('Dodržujeme pokyny třetí strany', $locale)); ?></li>
    <li><?php echo e(aiTrans('Implementujeme bezpečnostní opatření', $locale)); ?></li>
    <li><?php echo e(aiTrans('Informujeme o narušení dat', $locale)); ?></li>
    <li><?php echo e(aiTrans('Neposkytujeme subdodavatelské zpracování bez souhlasu', $locale)); ?></li>
    <li><?php echo e(aiTrans('Nezpracováváme údaje mimo Evropský hospodářský prostor bez souhlasu', $locale)); ?></li>
    <li><?php echo e(aiTrans('Pro elektronické marketingové komunikace zajišťujeme souhlas a možnosti odhlášení.', $locale)); ?></li>
</ul>
<h3><?php echo e(aiTrans('4. Bezpečnost', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Používáme administrativní, organizační a technická opatření k ochraně osobních údajů před neoprávněným přístupem, zveřejněním, změnou, ztrátou, zneužitím nebo poškozením. Při sdílení dat s třetími stranami zajišťujeme, že dodržují stejné standardy ochrany dat a jsou zavedeny smluvní závazky pro výhradní a bezpečné zpracování v souladu s těmito zásadami.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('Pokud existuje podezření, že byla interakce s námi narušena, návštěvníci, uživatelé nebo partneři by nás měli neprodleně informovat. Navzdory našim bezpečnostním opatřením nemůžeme zaručit úplnou imunitu proti útokům třetích stran. Uživatelé si jsou vědomi souvisejících rizik a možného narušení.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('5. Cookies', $locale)); ?></h3>
<p>


    <?php echo e(aiTrans('Podívejte se na naše', $locale)); ?> <a href="<?php echo e(route('home',$country)); ?>"><?php echo e(aiTrans('Zásady používání cookies', $locale)); ?></a> <?php echo e(aiTrans('pro podrobné informace o typech cookies a sledovacích technologiích používaných na webu, důvodech jejich použití a možnostech jejich přijetí nebo odmítnutí.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('6. Odkazy na jiné webové stránky', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Při procházení webu mohou uživatelé narazit na odkazy na externí webové stránky, které nejsou pod naší kontrolou. Nejsme odpovědní za obsah nebo zásady ochrany osobních údajů těchto stránek. Uživatelům doporučujeme, aby si před zveřejněním jakýchkoli osobních údajů přečetli zásady ochrany osobních údajů těchto stránek a služeb třetích stran.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('7. Uchovávání a vymazání údajů', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Údaje, včetně osobních údajů, nebudou uchovávány déle, než je nezbytné. Návštěvníci a/nebo uživatelé s aktivními účty nesou odpovědnost za včasné vymazání svých údajů. Po ukončení účtu nebo partnerství budou osobní údaje shromážděné prostřednictvím webu a/nebo služeb odstraněny v souladu s platnými zákony a našimi interními zásadami.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('Odvolání souhlasu se zpracováním osobních údajů může omezit přístup k některým nebo všem požadovaným službám, bez možnosti podání stížnosti nebo nároku.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('8. Vaše práva', $locale)); ?></h3>
<p><?php echo e(aiTrans('Uživatelé mají specifická práva týkající se jejich osobních údajů:', $locale)); ?></p>
<h4><?php echo e(aiTrans('8.1. Právo na přístup', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Potvrzení, zda jsou osobní údaje zpracovávány', $locale)); ?></li>
    <li><?php echo e(aiTrans('Přístup k osobním údajům a souvisejícím informacím', $locale)); ?></li>
    <li><?php echo e(aiTrans('Informace o účelu zpracování, kategoriích údajů, příjemcích, době uchovávání, právech a existenci profilování', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.2. Právo na opravu', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Oprava nepřesných osobních údajů', $locale)); ?></li>
    <li><?php echo e(aiTrans('Doplnění neúplných osobních údajů', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.3. Právo na vymazání', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Požadovat vymazání osobních údajů za určitých podmínek', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.4. Právo na omezení zpracování', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Získat omezení zpracování za určitých podmínek', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.5. Právo na přenositelnost údajů', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Obdržet osobní údaje ve strukturovaném a strojově čitelném formátu', $locale)); ?></li>
    <li><?php echo e(aiTrans('Přenést osobní údaje jinému správci', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.6. Právo vznést námitku', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Vznést námitku proti zpracování na základě oprávněného zájmu nebo přímého marketingu', $locale)); ?></li>
    <li><?php echo e(aiTrans('Zastavit zpracování, pokud neexistují závažné a/nebo právní důvody pro jeho pokračování', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.7. Právo odvolat souhlas', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Odvolat souhlas se zpracováním osobních údajů kdykoli', $locale)); ?></li>
</ul>
<h3><?php echo e(aiTrans('9. Reklamní a marketingové materiály', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Souhlas je získán pro použití osobních údajů a kontaktních údajů k poskytování reklamních a marketingových materiálů. Odvolání souhlasu je možné zasláním písemného oznámení na uvedenou e-mailovou adresu.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('10. Přijetí těchto zásad', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Používáním webu a/nebo služeb se předpokládá, že návštěvníci, uživatelé a/nebo partneři si tyto zásady přečetli a souhlasili s nimi. Jakýkoli nesouhlas znamená zdržení se používání platformy. Vyhrazujeme si právo zásady měnit a uživatelé jsou vyzýváni k pravidelnému ověřování aktualizací. Pokračování v používání po změnách znamená jejich přijetí.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('11. Zákonná povinnost zveřejnit osobní údaje', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Osobní údaje mohou být zveřejněny bez předchozího souhlasu, pokud existuje přesvědčení, že je to nutné k ověření identity, kontaktování nebo zahájení právních kroků proti jednotlivcům podezřelým z porušování práv nebo majetku. Zveřejnění bude provedeno, pokud to vyžaduje zákon.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('12. Pověřenec pro ochranu údajů', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Pro dotazy týkající se soukromí a ochrany údajů může být kontaktován určený "Pověřenec pro ochranu údajů" na e-mailové adrese', $locale)); ?> <span >info<?php echo e('@'.$website_title); ?></span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>




    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/clcl22oneall22/public_html/allclcl22.com/resources/views/frontend/cs/privacy.blade.php ENDPATH**/ ?>