<?php

namespace App\Http\Controllers\Dashboard\Core;

use App\Http\Controllers\Controller;
use Spatie\Translatable\HasTranslations;

class GeneralController extends Controller
{
    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function ModelSelectAjax()
    {
        $userClass = 'App\Domain\Core\Models\Administration\User';
        $model = request('modelClass');

        $columnName = request('columnName');
        $whereColumnName = request('whereColumnName');
        $whereColumnId = request('whereColumnId');
        $excludeId = request('exclude_id');
        $query = $model::query();
        $modelClass = app($model);

        if (request('modelClass') == $userClass) {
            $data = $query->whereHas('shareHolder', function ($q) use ($excludeId) {
                return $q->when($excludeId, function ($query, $excludeId) {
                    $query->where('id', '!=', $excludeId);
                })->where('type', '!=', 'dead');
            })->role('user');
        }

        if (request()->has('q')) {
            $search = str_replace("'", "\\'", strtolower(request('q')));

            if (in_array(HasTranslations::class, class_uses($modelClass::class), true)
                && in_array($columnName, $modelClass->getTranslatableAttributes())) {
                $data = $query->whereRaw("JSON_EXTRACT({$columnName}, '$.ar') like '%{$search}%'")
                    ->orWhereRaw("lower(JSON_EXTRACT({$columnName}, '$.en')) like '%{$search}%'")
                    ->select(["{$columnName}->" . app()->getLocale() . ' as text', 'id'])->paginate();
            } else {
                $data = $query
                    ->where($columnName, "like", "%{$search}%")
                    ->select(["{$columnName} as text", 'id'])->paginate();
            }
        } else {
            if ($whereColumnName && $whereColumnId) {
                $data = $query->where($whereColumnName, $whereColumnId);
            }

            if (in_array(HasTranslations::class, class_uses($modelClass::class), true)
                && in_array($columnName, $modelClass->getTranslatableAttributes())) {
                $data = $query->select(["{$columnName}->" . app()->getLocale() . ' as text', 'id'])->paginate();
            } else {
                $data = $query->select(["{$columnName} as text", 'id'])->paginate();
            }

            $data->getCollection()->transform(function ($item) {
                $item->text = strip_tags($item->text);

                return $item;
            });
        }

        return response()->json($data);
    }

    /**
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function SelectedModel($id)
    {
        $columnName = request('columnName');
        $model = request('modelClass');
        $modelClass = app($model);
        if (in_array(HasTranslations::class, class_uses($modelClass::class), true)
            && in_array($columnName, $modelClass->getTranslatableAttributes())) {
            $selected = $model::select(['*', "{$columnName}->" . app()->getLocale() . ' AS text'])
                ->where('id', $id)->first();
        } else {
            $selected = $model::select(["{$columnName} as text", 'id'])->where('id', $id)->first();
        }


        return response()->json($selected);
    }
}
