<?php

namespace App\Http\Middleware;

use Closure;
use App;
use Session;
class SetLocale
{
    protected $countryLanguageMap = [
        'en' => 'en',  // United States -> English
        'uk' => 'en',  // United Kingdom -> English
        'fr' => 'fr',  // France -> French
        'ru' => 'ru',  // Russia -> Russian
        'es' => 'es',  // Spain -> Spanish
        'de' => 'de',  // Germany -> German
        'ar' => 'ar',  // Germany -> German
        // Add more mappings as needed
    ];
    public function handle($request, Closure $next)
    {
        // Get the country parameter from the route
        $country = $request->route('country');

        // If the country is present in the URL and it's different from the current session country
        if ($country) {
            // Check if the country has a mapped default language
            $defaultLanguage = $this->countryLanguageMap[$country] ?? config('app.locale');

            // If the session doesn't have the language set for this country, update it
            if (Session::get('country') !== $country) {
                // Set the session's locale to the default language of the country
                Session::put('locale', $defaultLanguage);
                Session::put('country', $country);
            }
        }

        // Set the application's locale to the language stored in the session
        App::setLocale(Session::get('locale'));

        return $next($request);
    }
}
