<?php

namespace App\Http\Requests\API\Order;

use Carbon\Carbon;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules\Password;

class OrderRequest extends FormRequest
{
    public function rules()
    {

        $rules = [
            'type' => 'required|string|in:spare_part,appointment,wench',
            'brand_id' => 'required|integer|exists:brands,id,deleted_at,NULL',
            'car_type_id' => 'required|integer|exists:car_types,id,deleted_at,NULL',
            'user_car_id' => 'required|integer|exists:user_cars,id',
            'branch_id' => 'required_if:from_branch,==,1|integer|exists:branches,id,deleted_at,NULL',
            'problem_id' => 'required_if:type,==,wench|integer|exists:problems,id,deleted_at,NULL',
            'company_id' => 'sometimes|nullable|integer|exists:companies,id,deleted_at,NULL',
            'discount_percentage' => 'sometimes|nullable|string',
            'customer_note' => 'sometimes|nullable|string',
            'maintenance_days' => 'sometimes|nullable|integer',
            'reservation_time' => 'required_if:type,==,wench,appointment|date',
            'address' => 'required_if:type,==,wench|string',
            'lat' => 'required_if:type,==,wench|string',
            'lng' => 'required_if:type,==,wench|string',
            'address_return' => ['string', Rule::requiredIf(function () {
                return $this->input('type') == 'wench' && $this->input('delivery_direction') == 'twoWay';
            })],
            'lat_return' => ['string', Rule::requiredIf(function () {
                return $this->input('type') == 'wench' && $this->input('delivery_direction') == 'twoWay';
            })],
            'lng_return' => ['string', Rule::requiredIf(function () {
                return $this->input('type') == 'wench' && $this->input('delivery_direction') == 'twoWay';
            })],
            'delivery_direction' => 'required_if:type,==,wench|string',
            'user_address_id' => [
                Rule::requiredIf(function () {
                    return $this->input('type') == 'spare_part' && $this->input('from_branch') == 0;
                }),
                'exists:user_addresses,id',
                function ($attribute, $value, $fail) {
                    // Check if the user_address_id belongs to the authenticated user
                    $user = auth('sanctum')->user();

                    if (!$user || !$user->addresses()->where('id', $value)->exists()) {
                        $fail('The selected user address is not valid for the authenticated user.');
                    }
                },
            ]
            ,
            'services' => 'sometimes|nullable|array',
            'services.*.service_id' => 'sometimes|nullable|exists:services,id,deleted_at,NULL',
            'spare_parts' => 'sometimes|nullable|array',
            'spare_parts.*.spare_part_id' => 'sometimes|nullable|exists:spare_parts,id,deleted_at,NULL'
        ];

        if (request()->isMethod('put')) {
            $rules['user_id'] = 'sometimes|nullable|integer|exists:users,id';
            $rules['branch_id'] = 'sometimes|nullable|integer|exists:branches,id';
            $rules['car_type_id'] = 'sometimes|nullable|integer|exists:car_types,id';
            $rules['brand_id'] = 'sometimes|nullable|integer|exists:brands,id';
            $rules['problem_id'] = 'sometimes|nullable|integer|exists:problems,id';
            $rules['type'] = 'sometimes|nullable|string';
            $rules['reservation_time'] = 'sometimes|nullable|date';
        }
        return $rules;

    }
}
