<x-ui::layout title="{{ __('Dashboard') }}">
    @push('header')
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css"/>
        <link href="https://fonts.googleapis.com/css?family=Titillium+Web:400,600,700" rel="stylesheet"/>
        <!-- Add these CSS stylesheets -->
        <link href="{{ asset('vendor/hsmfawaz/ui/metronic/assets/plugins/custom/fullcalendar/fullcalendar.bundle.css') }}
            " rel="stylesheet" type="text/css"/>
        <link rel="stylesheet"
              href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.print.min.css"
              crossorigin="anonymous" media="print"/>

    @endpush


    <div class="post d-flex flex-column-fluid" id="kt_post">
        <!--begin::Container-->
        <div id="kt_content_container" class="container-xxl">
            <!--begin::Row-->
            <div class="row g-5 g-xl-10 mb-xl-10">
                @include('dashboard.dashboard-sections.cards')
            </div>


            <!--end::Container-->
            <!--begin::Row-->
            <div class="row g-5 g-xl-10 mb-xl-10">
                <!--begin::calendar-->
                <div id="calendar"></div>
                <!--end::calendar-->
            </div>
            <!--end::Container-->
        </div>


        <x-slot:scripts>
            <script src="{{ asset('dashboard-assets/js/apexcharts.js') }}"></script>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"
                    crossorigin="anonymous"></script>
            <script src="{{ asset('vendor/hsmfawaz/ui/metronic/assets/js/custom/widgets.js')}}"></script>


            <script src="{{ asset('vendor/hsmfawaz/ui/metronic/assets/plugins/custom/fullcalendar/fullcalendar.bundle.js') }}
            "></script>

           {{--
            <script>
                $(document).ready(function () {
                    let initialLocaleCode = "{{app()->getLocale()}}";
                    // Define colors
                    let green = KTUtil.getCssVariableValue("--bs-active-success");
                    let red = KTUtil.getCssVariableValue("--bs-active-danger");
                    let blue = KTUtil.getCssVariableValue("--bs-active-primary");
                    // Initialize Fullcalendar -- for more info please visit the official site: https://fullcalendar.io/demos
                    let calendarEl = document.getElementById("calendar");
                    let calendar = new FullCalendar.Calendar(calendarEl, {
                        headerToolbar: {
                            left: "prev,next today",
                            center: "title",
                            right: "dayGridMonth,dayGridWeek,dayGridDay,listMonth"
                        },
                        locale: initialLocaleCode,
                        navLinks: true, // can click day/week names to navigate views
                        businessHours: true, // display business hours
                        editable: true,
                        selectable: true,
                        selectMirror: true,
                        dayMaxEvents: true, // allow "more" link when too many events
                        events: [
                                @foreach ($orders as $order)
                            {
                                title: '{{__('Order Num')}} : #{{ $order->order_num }}',
                                start: '{{ \Carbon\Carbon::parse($order->reservation_time)->toDateTimeString() }}',
                                constraint: "businessHours",
                                url: "{{route('dashboard.order.orders.edit',$order->id)}}",
                                overlap: true,
                                color: @if($order->type == 'appointment') {{'blue'}}
                                        @elseif($order->type == 'spare_part') {{'red'}}  @else {{'green'}} @endif,
                            },
                            @endforeach
                        ],
                        // Delete event

                    });

                    calendar.render();

                });
            </script>


            <script>
                let KTChartsWidget3 = {
                    init: function () {
                        !function () {
                            let e = document.getElementById("kt_charts_widget_3");
                            if (e) {
                                let a = parseInt(KTUtil.css(e, "height")),
                                    t = KTUtil.getCssVariableValue("--bs-gray-500"),
                                    l = KTUtil.getCssVariableValue("--bs-border-dashed-color"),
                                    o = KTUtil.getCssVariableValue("--bs-success"),
                                    r = KTUtil.getCssVariableValue("--bs-success"),
                                    i = new ApexCharts(e, {
                                        series: [{
                                            name: "Sales",
                                            data: {!! json_encode($earnings) !!}
                                        }],
                                        chart: {fontFamily: "inherit", type: "area", height: a, toolbar: {show: !1}},
                                        plotOptions: {},
                                        legend: {show: !1},
                                        dataLabels: {enabled: !1},
                                        fill: {
                                            type: "gradient",
                                            gradient: {
                                                shadeIntensity: 1,
                                                opacityFrom: .4,
                                                opacityTo: 0,
                                                stops: [0, 80, 100]
                                            }
                                        },
                                        stroke: {curve: "smooth", show: !0, width: 3, colors: [o]},
                                        xaxis: {
                                            categories: {!! json_encode($allMonths) !!},
                                            axisBorder: {show: !1},
                                            axisTicks: {show: !1},
                                            tickAmount: 12,
                                            labels: {rotate: 0, rotateAlways: !0, style: {colors: t, fontSize: "15px"}},
                                            crosshairs: {position: "front", stroke: {color: o, width: 1, dashArray: 3}},
                                            tooltip: {
                                                enabled: !0,
                                                formatter: void 0,
                                                offsetY: 0,
                                                style: {fontSize: "15px"}
                                            }
                                        },
                                        yaxis: {
                                            tickAmount: 10,
                                            max: {{$maxEarn ?? 100}},
                                            min: {{$minEarn ?? 0}},
                                            labels: {
                                                style: {colors: t, fontSize: "12px"}, formatter: function (e) {
                                                    return "SAR " + e.toFixed(2)
                                                }
                                            },
                                        },
                                        states: {
                                            normal: {filter: {type: "none", value: 0}},
                                            hover: {filter: {type: "none", value: 0}},
                                            active: {
                                                allowMultipleDataPointsSelection: !1,
                                                filter: {type: "none", value: 0}
                                            }
                                        },
                                        tooltip: {
                                            style: {fontSize: "12px"}, y: {
                                                formatter: function (e) {
                                                    return "SAR " + e.toFixed(2)
                                                }
                                            }
                                        },
                                        colors: [r],
                                        grid: {borderColor: l, strokeDashArray: 4, yaxis: {lines: {show: !0}}},
                                        markers: {strokeColor: o, strokeWidth: 3}
                                    });
                                setTimeout((function () {
                                    i.render()
                                }), 200)
                            }
                        }()
                    }
                };
                "undefined" != typeof module && (module.exports = KTChartsWidget3), KTUtil.onDOMContentLoaded((function () {
                    KTChartsWidget3.init()
                }));
            </script>--}}
            @stack('js')
        </x-slot:scripts>
</x-ui::layout>
