@extends('layouts.app')

@section('content')
<div class="hero wf-section">
    <div class="container w-container">
        <h1 class="hero-header">{{$website_title}}</h1>
        <h3 class="hero-subtitle">
            {{ aiTrans(
                "Revolutionizing cryptocurrency trading: introducing the latest update of [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
        <div class="main-cols">
            <div class="video-col">
                <img src="dist/images/poster_index.webp" 
                     sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw" 
                     srcset="{{ asset('frontend/assets/pt/dist') }}/images/poster_index-p-500.webp 500w, 
                             {{ asset('frontend/assets/pt/dist') }}/images/poster_index.webp 733w" 
                     alt="{{$website_title}} - Revolutionizing cryptocurrency trading: introducing the latest update of {{$website_title}}" 
                     width="710" height="399" class="main-image">
            </div>
            <div class="form-col">
                <div class="form-container">
                    <div id="formTop" class="form-box w-form-wrapper">
                        @include('frontend.en.components.form')
                        <div class="w-form-done">
                            <div>{{aiTrans('Thank you! Your submission has been received!')}}</div>
                        </div>
                        <div class="w-form-fail">
                            <div>{{aiTrans('Oops! Something went wrong while submitting the form.')}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-bg-2"></div>
    <div class="hero-bg-1"></div>
</div>

<div class="trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/trade-image.webp" width="500" 
         alt="{{$website_title}} - What is {{$website_title}}?" class="img-float-right no-float-on-991">
    <div class="container w-container">
        <h2 class="trading-title">
            {{ aiTrans(
                "What is [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="trading-text">
            {{ aiTrans(
                "We are pleased to announce the launch of the new version of [website_title] – the ultimate platform for cryptocurrency trading. 
                With advanced features, cutting-edge technology, and a user-friendly interface, the new [website_title] is designed to take your trading experience to the next level. 
                This powerful and intuitive trading software can take advantage of small price differences in digital currencies across different exchanges. 
                It then buys cryptocurrencies at a low price and sells them at a higher price. 
                The end result is small amounts of profit that accumulate into significant earnings for the user.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button margin-bottom-35 w-button">{{aiTrans("Register now")}}</a>
        </div>
        <h2 class="trading-title">{{aiTrans('How do I start trading online?')}}</h2>
        <div class="trading-text">
            {{aiTrans('Online trading, the basic buying and selling of financial assets over the Internet, can be done by almost anyone, regardless of prior experience in global financial markets. 
            While it is simple to start, if you plan to be profitable, online trading can be a challenge. 
            To start online trading, you will need a computer and a reliable internet connection. 
            After registering for a trading account with a reputable platform, you can begin trading as soon as your account is activated and funded...')}}
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("Register now")}}</a>
            <div class="trading-bg2"></div>
        </div>
    </div>
    <div class="trading-bg-1"></div>
</div>

<div class="not-scam w-clearfix wf-section">
    <div class="not-scam-bg-1"></div>
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/not-scam-img.webp" 
         alt="{{$website_title}} - Is {{$website_title}} a scam?" class="img-float-right not-scam-img">
    <div class="container w-container">
        <h3 class="not-scam-title">
            {{ aiTrans(
                "Is [website_title] a scam?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
        <p class="not-scam-text">
            {{ aiTrans(
                "No, it is not. [website_title] does not promise guaranteed profits from cryptocurrency trading because it is not an automated trading software. 
                The application is merely a trading assistant. 
                It is designed to help investors trade cryptocurrencies with confidence. 
                The app provides real-time, data-based insights for traders, helping them make quick and accurate decisions when trading their favorite cryptocurrencies online. 
                Additionally, the app is secure and does not compromise any personal or financial data of its users.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
        <div class="button-wrapper">
            <a href="#formTop" class="button white w-button">{{aiTrans("REGISTER NOW")}}</a>
        </div>
    </div>
</div>


<div class="improve-your-trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/improve-your-trading-img.webp" alt="{{$website_title}} - How does the {{$website_title}} app improve your trading?" class="img-float-right improve-your-trading-img">
    <div class="container w-container">
        <h2 class="improve-your-trading-title">
            {{ aiTrans(
                "How does the [website_title] app improve your trading?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="improve-your-trading-text">
            {{ aiTrans(
                "No matter your skill level in online trading, you can benefit from the powerful trading features offered by the [website_title] app. First, however, you need to understand how the software works. The [website_title] app is capable of analyzing markets using a highly sophisticated algorithm that incorporates large amounts of market data, as well as key technical indicators to identify high-probability trading setups. You can also adjust the parameters in the software's intuitive design interface. Simply modify how the software operates according to your own skill level, risk tolerance, and preferences. 

                The software allows even beginner traders to start trading in the markets without worrying about making mistakes when analyzing price movements and knowing when to enter a trade. Additionally, another great feature is that as you progress as a trader, you may want to take a more hands-on approach. In this situation, the software can still be highly useful for confirming your own market analysis before entering a trade. Even at a higher skill level, you may find yourself in situations where you are too nervous or excited to make logical trading decisions. In this case, you can rely on the market analysis provided by the app. This helps you avoid emotional trading errors, ensuring that your trades are based on data-driven market analysis.

                One of the best things about [website_title] is that registering a new account is completely free. Sign up now and start trading in the markets.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans('Open a free account now')}}</a>
        </div>
        <div class="improve-your-trading-bg"></div>
    </div>
    <div class="improve-your-trading-bg-2"></div>
</div>

<div class="features wf-section">
    <div class="container w-container">
        <div class="features-bg"></div>
        <h2 class="features-title">
            {{ aiTrans(
                "Key features of [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="features-text">
            {{ aiTrans(
                "[website_title] is the latest version of our powerful trading app, designed to help investors access and take full advantage of high-quality trading opportunities in the cryptocurrency markets. Our advanced financial technologies combine over 15 technical analysis tools to help traders identify the optimal price entry and exit points when trading their favorite digital currencies online. 

                The new [website_title] supports a wider range of cryptocurrencies, offering more options when it comes to trading. Whether you're interested in Bitcoin, Ethereum, or other popular cryptocurrencies, you can trade them on the new [website_title].",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="features-list w-row">
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature1-icon.webp" alt="{{$website_title}} - Advanced Trading Algorithms" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Advanced Trading Algorithms')}}</h3>
                    </div>
                    <div class="features-list-item-text">{{aiTrans('Our trading algorithms are more advanced than ever, allowing you to take advantage of real-time market movements. With sophisticated machine learning algorithms, [website_title] can analyze market data and make predictions about future price movements, giving you an edge in your trades.', $locale , ['website_title' => $website_title])}}</div>
                </div>
            </div>

            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature2-icon.webp" alt="{{$website_title}} - Enhanced User Interface" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Enhanced User Interface')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        
                        {{ aiTrans(
                            "We have completely redesigned our user interface, making it more intuitive and easier to use. Whether you are a beginner or an experienced trader, you will find the new [website_title] easy to navigate and use.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature3-icon.webp" alt="{{$website_title}} - Improved Security" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Improved Security')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        {{ aiTrans(
                            "Security is our top priority at [website_title], and the new platform includes a variety of advanced security features to keep your funds and personal information safe. Our platform is protected with SSL encryption and two-factor authentication, and we use the latest security protocols to safeguard your data.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </div>
                </div>
            </div>
        </div>
        <div class="button-wrapper margin-0-auto">
            <a href="#formTop" class="button w-button">{{aiTrans("REGISTER NOW")}}</a>
        </div>
    </div>
    <div class="features-bg-1"></div>
</div>
<div class="steps wf-section">
    <div class="container w-container">
        <h2 class="steps-title">
            {{ aiTrans(
                "How do you sign up with [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="steps-list w-row">
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Step One')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Sign Up')}}</h3>
                    </div>

                    <div>
                        {{ aiTrans(
                            "The first step is to fill out the registration form, which you can find on our website. You will be asked to provide basic information, such as your first name, last name, email address, and phone number. Once you receive the confirmation email and click on the confirmation link, you will be registered, and your new account will be activated. This means you will have full access to the [website_title] trading app.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Step Two')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Funding')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "After activating your new account, you will need to deposit funds into it. Trading requires capital to maintain your positions in the market. You will be required to invest a minimum amount of money to execute trades using the [website_title] app. The more you invest, the greater your potential profit. However, this also means an increased risk of loss. Beginners are advised to start cautiously and invest only the minimum deposit requirement. This will allow you to learn the basics of trading markets before investing additional funds.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Step Three')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Trading')}}</h3>
                    </div>
                    <div>{{aiTrans('Finally, you will need to adjust the trading parameters in the software. The app can be customized to suit your risk tolerance, preferences, and trading goals. This ensures that you have the best possible trading experience. Once you have finished setting up your trading parameters, you will be ready to start executing trades using our powerful algorithm and market analysis.')}}</div>
                </div>
            </div>
        </div>
        <div class="button-wrapper steps-action-button">
            <a href="#formTop" class="button white w-button">{{aiTrans('Sign up now to get started')}}</a>
        </div>
    </div>
</div>
<div class="faq wf-section">
    <div class="container w-container">
        <h2 class="faq-title">{{aiTrans('Frequently Asked Questions')}}</h2>
        <p class="faq-text">{{aiTrans('You probably still have some concerns about how our trading app works. If you are a beginner trader, you likely have questions about how to get started. Below are some of the most common questions we hear from traders.')}}</p>
        <div class="faq-accordion">
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">1</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "What is the new version of [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "The new version of [website_title] is an updated version of the popular cryptocurrency trading platform, designed to provide traders with even more powerful tools and features to help them succeed in the cryptocurrency market.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
            
            
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">2</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "What new features does the latest version of [website_title] offer?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "The latest version of [website_title] offers a variety of new features, including advanced risk management tools, real-time market data, customizable charts and graphs, and news and event analysis.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">3</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Is the latest version of [website_title] safe to use?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Yes, the latest version of [website_title] is safe to use. The platform uses advanced security measures to protect user data and transactions, and our team of experts monitors the platform 24/7 to ensure that it remains secure and reliable.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">4</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Can I customize my trading experience with the latest version of [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Yes, the latest version of [website_title] allows you to customize your trading experience, including customizable charts and graphs that make it easy to view market data and trends.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">5</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Is the latest version of [website_title] suitable for beginners?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Yes, the latest version of [website_title] is suitable for beginners. The platform is user-friendly and easy to navigate, and our team of experts is available to provide guidance and support for traders at all levels of experience.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("REGISTER NOW")}}!</a>
        </div>
    </div>

    <div class="faq-bg-2"></div>
    <div class="faq-bg-3"></div>
</div>
<div class="highlights-section wf-section">
    <div class="container w-container">
        <h2 class="faq-title">
            {{ aiTrans(
                "[website_title] Highlights",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="high-table">
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-1.webp" alt="Highlights" class="high-img">
                    <div class="high-text">{{aiTrans('Type')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('AI Trading Robot')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Highlights" class="high-img">
                    <div class="high-text">{{aiTrans('App Cost')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Free')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-3.webp" alt="Highlights" class="high-img">
                    <div class="high-text">Fees</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('No')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-4.webp" alt="Highlights" class="high-img">
                    <div class="high-text">{{aiTrans('Demo Account')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Yes')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Highlights" class="high-img">
                    <div class="high-text">{{aiTrans('Assets')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('BTC, ETH, XRP, DASH, and others')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-6.webp" alt="Highlights" class="high-img">
                    <div class="high-text">{{aiTrans('User Data Protection')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Yes')}}</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
