@extends('layouts.app')
@section('title', $website_title .' | OM OSS')
@php( $meta_description = "Finn ut hvordan ". $website_title." hjelper deg med å utvikle ferdighetene dine i kryptovalutainvestering. Vi tilbyr avanserte verktøy og full støtte for å nå dine handelsmål.")

@section('content')
<div class="what-is w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/what-is-img.webp"  sizes="(max-width: 991px) 100vw, (max-width: 2870px) 50vw, 1435px" alt="{{$website_title}}  - Hva er akkurat online handel?" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h1 class="about-title">{{aiTrans('Om oss')}}</h1>
        <h2 class="about-subtitle">{{aiTrans('Hva er akkurat online handel?')}}</h2>
        <p>{{aiTrans('Online handel startet i 1971, da den første handelsprogramvaren, National Association of Securities Dealers Automated Quotations (NASDAQ), ble lansert som den første online handelsprogramvaren. I dag er online handel den mest populære metoden for kjøp og salg av ulike finansielle eiendeler som Forex, kryptovalutaer, aksjer, råvarer og til og med kontrakter for forskjeller (CFD-er).')}}</p>
        <p>
            {{ aiTrans(
                "Basert på dette, ble [website_title] født.",
                $locale,
                ['website_title' => $website_title],
            ) }}</p>
        <p>{{aiTrans('Den kraftige og intuitive handelsprogramvaren er i stand til å utnytte de små prisforskjellene på digitale valutaer mellom de ulike børsene. Den vil deretter kjøpe kryptovalutaer til lav pris og selge dem til høyere pris. Det endelige resultatet er små profittbeløp som resulterer i store gevinster for brukeren.')}}</p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Se videoen')}}</a>
        </div>
    </div>
    <div class="what-is-bg-1"></div>
</div>

<div class="how-it-working wf-section">
    <div class="container w-container">
        <div class="how-it-working-text">
            {{ aiTrans(
                "Kryptovalutaer er svært volatile eiendeler, og det er viktig å ta gode beslutninger når du handler dem. Det er hva [website_title] handler om. Den kraftige applikasjonen sikrer at kryptoinvestorer kan få rask og relevant informasjon når de handler sine favorittmynter og tokens på markedet. På denne måten kan de følge de beste mulighetene på kryptomarkedene og ta presise og informerte handelsbeslutninger hele tiden. [website_title] sørger for at ingen kryptoinvestor handler blindt. Applikasjonen lar deg handle med tillit og få mest mulig ut av din handelsaktivitet.",
                $locale,
                ['website_title' => $website_title],
            ) }}</div>
    </div>
</div>

<div class="our-team w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/our-team-img.webp"  sizes="(max-width: 991px) 100vw, 50vw" alt="{{$website_title}}  - Teamet bak {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-team-title">
            {{ aiTrans(
                "Teamet bak [website_title] ",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "Teamet bak [website_title] består av dedikerte handelspersoner som ønsker å gi vanlige folk, akkurat som deg, muligheten til å handle Bitcoin og andre kryptovalutaer på en effektiv og lønnsom måte. Teamet har kombinert sin kunnskap og erfaring for å skape en handelsprogramvare som raskt og enkelt kan skanne forskjellige kryptobørser og identifisere lønnsomme handelsmuligheter. Hele prosessen er automatisert, slik at hvem som helst kan handle og få sin andel av denne lukrative kaken.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "[website_title] tilbyr mange fordeler og fordeler, og vi er alltid forpliktet til å bidra positivt til din handelsopplevelse og økonomiske reise.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Registrer deg nå')}}</a>
        </div>
    </div>
</div>
<div class="our-advantage w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/advantage-img.webp"  alt="{{$website_title}}  - Utnytt kryptomarkedene og tjen med" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-advantage-title">
            {{ aiTrans(
                "Utnytt kryptomarkedene og tjen med [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "Hos [website_title] ønsker vi å hjelpe deg med å oppnå økonomisk frihet, og ettersom kryptomarkedet vokser og utvikler seg, er det ingen tvil om at flere handelsmuligheter vil oppstå. Dette betyr rett og slett mer profitt for deg.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "Ta kontroll over fremtiden din i dag og registrer deg med [website_title]. Din suksess vil endre livet ditt. Registrer deg nå for din gratis konto og bli med i handelsaktiviteten i dag!",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
    </div>
</div>
@endsection
