@extends('layouts.app')

@section('content')
<div class="hero wf-section">
    <div class="container w-container">
        <h1 class="hero-header">{{$website_title}}</h1>
        <h3 class="hero-subtitle">
            {{ aiTrans(
                "Revolúcia v obchodovaní s kryptomenami: predstavujeme najnovšiu aktualizáciu [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
        <div class="main-cols">
            <div class="video-col"><img src="dist/images/poster_index.webp" sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw" srcset="{{ asset('frontend/assets/pt/dist') }}/images/poster_index-p-500.webp 500w, {{ asset('frontend/assets/pt/dist') }}/images/poster_index.webp 733w" alt="{{$website_title}} - Revolúcia v obchodovaní s kryptomenami: predstavujeme najnovšiu aktualizáciu {{$website_title}}" width="710" height="399" class="main-image"></div>
            <div class="form-col">
                <div class="form-container">
                    <div id="formTop" class="form-box w-form-wrapper">
                        @include('frontend.sk.components.form')
                        <div class="w-form-done">
                            <div>{{aiTrans('Ďakujeme! Vaša žiadosť bola prijatá!')}}</div>
                        </div>
                        <div class="w-form-fail">
                            <div>{{aiTrans('Oops! Pri odosielaní formulára došlo k chybe.')}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-bg-2"></div>
    <div class="hero-bg-1"></div>
</div>
<div class="trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/trade-image.webp" width="500" alt="{{$website_title}} - Čo je {{$website_title}}?" class="img-float-right no-float-on-991">
    <div class="container w-container">
        <h2 class="trading-title">
            {{ aiTrans(
                "Čo je [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="trading-text">
            {{ aiTrans(
                "S radosťou oznamujeme vydanie novej verzie [website_title] – definitívnej platformy pre obchodovanie s kryptomenami. S pokročilými funkciami, špičkovou technológiou a užívateľsky prívetivým rozhraním bola nová verzia [website_title] navrhnutá tak, aby posunula vašu obchodnú skúsenosť na ďalšiu úroveň. Výkonný a intuitívny obchodný softvér je schopný využiť malé cenové rozdiely medzi digitálnymi menami na rôznych burzách. Potom ich kúpi za nízku cenu a predá za vyššiu. Konečný výsledok sú malé zisky, ktoré vedú k veľkým výnosom pre používateľa.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button margin-bottom-35 w-button">{{aiTrans("Zaregistrovať sa teraz")}}</a>
        </div>
        <h2 class="trading-title">{{aiTrans('Ako začať obchodovať online?')}}</h2>
        <div class="trading-text">{{aiTrans('Online obchodovanie, základný nákup a predaj finančných aktív cez internet, môže robiť takmer každý, bez ohľadu na predchádzajúce skúsenosti s globálnymi finančnými trhmi. Aj keď je jednoduché začať, ak chcete byť ziskoví, online obchodovanie môže byť výzvou. Aby ste začali obchodovať online, potrebujete počítač a spoľahlivé internetové pripojenie. Po registrácii na obchodnú platformu s rešpektovanou platformou môžete začať obchodovať hneď po aktivácii a financovaní svojho účtu. Zaujímavé je, že hoci je ľahké začať obchodovať, oveľa ťažšie je byť úspešným obchodníkom. Existuje množstvo rizík, o ktorých by ste mali vedieť. Veľká časť obchodovania súvisí s metodickým plánovaním, presnou analýzou trhu, porozumením faktorom ovplyvňujúcim ceny aktív, ako aj pokusmi a omylmi. Niektoré trhy aktív môžu byť veľmi volatilné, čo môže zvýšiť vaše riziko straty, ak nemáte zručnosti využiť množstvo ziskových obchodných príležitostí, ktoré volatilita môže ponúknuť. Napriek týmto výzvam sa s technologickými pokrokmi v algoritmickej technológii tento typ obchodného softvéru stal jednoduchším než kedykoľvek predtým na presnejšie online obchodovanie. Algoritmus aplikácie analyzuje trhy na identifikáciu obchodných príležitostí a s týmito informáciami môžete robiť inteligentnejšie obchodné rozhodnutia na základe analýzy trhu. Týmto spôsobom môžu aj nováčikovia začať obchodovať s preferovanými aktívami online.')}}</div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("Zaregistrovať sa teraz")}}</a>
            <div class="trading-bg2"></div>
        </div>
    </div>
    <div class="trading-bg-1"></div>
</div>
<div class="not-scam w-clearfix wf-section">
    <div class="not-scam-bg-1"></div>
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/not-scam-img.webp" alt="{{$website_title}} - {{$website_title}} je podvod?" class="img-float-right not-scam-img">
    <div class="container w-container">
        <h3 class="not-scam-title">
            {{ aiTrans(
                "[website_title] je podvod?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
<p class="not-scam-text">
    {{ aiTrans(
        "Nie, nie je. [website_title] nesľubuje zaručené zisky z obchodovania s kryptomenami, pretože nie je automatizovaný obchodný softvér. Aplikácia je iba asistentom obchodovania. Bola navrhnutá na pomoc investorom pri obchodovaní s kryptomenami s dôverou. Aplikácia poskytuje informácie založené na reálnych údajoch v reálnom čase pre obchodníkov, pomáhajúc im robiť rýchle a presné rozhodnutia pri obchodovaní s obľúbenými kryptomenami online. Okrem toho je aplikácia bezpečná a neohrozuje žiadne osobné ani finančné údaje svojich klientov.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</p>
<div class="button-wrapper">
    <a href="#formTop" class="button white w-button">{{aiTrans("ZAREGISTROVAŤ SA TERAZ")}}</a>
</div>
</div>
</div>
<div class="improve-your-trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/improve-your-trading-img.webp" alt="{{$website_title}} - Ako aplikácia {{$website_title}} zlepšuje vaše obchodovanie?" class="img-float-right improve-your-trading-img">
    <div class="container w-container">
        <h2 class="improve-your-trading-title">
            {{ aiTrans(
                "Ako aplikácia [website_title] zlepšuje vaše obchodovanie?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="improve-your-trading-text">
            {{ aiTrans(
                "Nezáleží na úrovni vašich zručností v online obchodovaní, môžete využívať silné obchodné funkcie ponúkané aplikáciou [website_title]. Predtým však budete musieť pochopiť, ako softvér funguje. [website_title] je schopný analyzovať trhy pomocou vysoko sofistikovaného algoritmu, ktorý zahŕňa veľké množstvo trhových dát, ako aj niektoré dôležité technické indikátory na identifikáciu obchodných nastavení s vysokou pravdepodobnosťou. Takisto budete môcť prispôsobiť parametre v intuitívnom rozhraní softvéru. Stačí prispôsobiť, ako softvér funguje, podľa vašich vlastných zručností, tolerancie k riziku a preferencií. Softvér umožňuje aj začiatočníkom začať obchodovať na trhoch bez obáv z chýb pri analýze pohybov cien na trhoch a vedieť, kedy vstúpiť do obchodu. Okrem toho, ďalšou skvelou funkciou je, že keď začnete postupovať ako obchodník, môžete sa rozhodnúť prijať viac praktický prístup. V tomto prípade môže byť softvér stále veľmi užitočný na potvrdenie vašej vlastnej trhovej analýzy pred vstupom do obchodu. Aj na vyššej úrovni zručností sa môžete ocitnúť v situáciách, keď môžete byť príliš nervózni alebo nadšení na to, aby ste robili logické obchodné rozhodnutia. V tomto prípade môžete využiť analýzu trhu poskytnutú aplikáciou. To vám umožní vyhnúť sa chybám v obchodovaní na základe emócií a zabezpečiť, že sa zapájate do obchodov na základe analýz trhu založených na dátach. Jednou z najlepších vecí na [website_title] je, že registrácia novej účtu je úplne zadarmo. Zaregistrujte sa teraz a začnite obchodovať na trhoch.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans('Otvor si bezplatný účet teraz')}}</a>
        </div>
        <div class="improve-your-trading-bg"></div>
    </div>
    <div class="improve-your-trading-bg-2"></div>
</div>
<div class="features wf-section">
    <div class="container w-container">
        <div class="features-bg"></div>
        <h2 class="features-title">
            {{ aiTrans(
                "Hlavné vlastnosti [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="features-text">
            {{ aiTrans(
                "[website_title] je najnovšia verzia našej silnej obchodnej aplikácie, navrhnutá na pomoc investorom pri prístupe a maximalizovaní obchodných príležitostí v kryptomienach. Naše pokročilé finančné technológie kombinujú viac ako 15 nástrojov technickej analýzy, ktoré pomáhajú obchodníkom identifikovať ideálne body vstupu a výstupu pri obchodovaní s ich obľúbenými digitálnymi menami online. Nové [website_title] podporuje širšiu škálu kryptomien, ponúkajúc viac možností v obchodovaní. Či už máte záujem o Bitcoin, Ethereum alebo iné populárne kryptomeny, môžete ich obchodovať v novom [website_title].",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="features-list w-row">
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature1-icon.webp" alt="{{$website_title}} - Pokročilé obchodné algoritmy" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Pokročilé obchodné algoritmy')}}</h3>
                    </div>
                    <div class="features-list-item-text">{{aiTrans('Naše obchodné algoritmy sú pokročilejšie ako kedykoľvek predtým, čo vám umožňuje využiť pohyby trhu v reálnom čase. S pokročilými algoritmami strojového učenia môže [website_title] analyzovať trhové dáta a predpovedať budúce pohyby cien, čo vám dáva výhodu pri vašich obchodoch.', $locale , ['website_title' => $website_title])}}</div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature2-icon.webp" alt="{{$website_title}} - Vylepšené používateľské rozhranie" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Vylepšené používateľské rozhranie')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        
                        {{ aiTrans(
                            "Úplne sme redesignovali naše používateľské rozhranie, aby bolo intuitívnejšie a ľahšie použiteľné. Či už ste začiatočník alebo skúsený obchodník, nový [website_title] bude pre vás jednoduchý na navigáciu a používanie.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature3-icon.webp" alt="{{$website_title}} - Zlepšená bezpečnosť" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Zlepšená bezpečnosť')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        {{ aiTrans(
                            "Bezpečnosť je našou hlavnou prioritou v [website_title], a nová platforma obsahuje rôzne pokročilé bezpečnostné funkcie na ochranu vašich financií a osobných informácií. Naša platforma je chránená pomocou šifrovania SSL a dvojfaktorovej autentifikácie a používame najnovšie bezpečnostné protokoly na ochranu vašich údajov.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
        </div>
        <div class="button-wrapper margin-0-auto">
            <a href="#formTop" class="button w-button">{{aiTrans("ZAREGISTROVAŤ SA TERAZ")}}</a>
        </div>
    </div>
    <div class="featues-bg-1"></div>
</div>
<div class="steps wf-section">
    <div class="container w-container">
        <h2 class="steps-title">
            {{ aiTrans(
                "Ako sa zaregistrujete s [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="steps-list w-row">
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Krok 1')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Registrácia')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "Prvým krokom je vyplniť registračný formulár, ktorý nájdete na našej stránke. Budete požiadaní o poskytnutie základných informácií, ako je vaše meno, priezvisko, e-mailová adresa a telefónne číslo. Po obdržaní potvrdenia e-mailom a kliknutí na potvrdzovací odkaz budete zaregistrovaní a váš nový účet bude aktivovaný. To znamená, že získate plný prístup k obchodnej aplikácii [website_title].",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Krok dva')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Financovanie')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "Po aktivácii vášho nového účtu budete musieť vložiť prostriedky na svoj účet. Obchodovanie vyžaduje kapitál na udržanie pozícií na trhu. Budete musieť investovať minimálnu sumu peňazí, aby ste mohli obchodovať pomocou aplikácie [website_title]. Čím viac investujete, tým väčší zisk môžete potenciálne dosiahnuť. Avšak to tiež znamená vyššie riziko straty. Začiatočníkom sa odporúča začať s minimálnym vkladom. To vám umožní naučiť sa základy obchodovania na trhoch pred tým, ako investujete viac peňazí.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Krok tri')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Obchodovanie')}}</h3>
                    </div>
                    <div>{{aiTrans('Nakoniec budete musieť nastaviť parametre obchodovania v softvéri. Aplikáciu môžete prispôsobiť podľa vlastnej tolerancie k riziku, preferencií a obchodných cieľov. To zabezpečí, že budete mať najlepšiu obchodnú skúsenosť. Po nastavení parametrov obchodovania budete pripravení začať obchodovať s využitím nášho výkonného algoritmu a analýzy trhu.')}}</div>
                </div>
            </div>
        </div>
        <div class="button-wrapper steps-action-button">
            <a href="#formTop" class="button white w-button">{{aiTrans('Zaregistrujte sa teraz a začnite')}}</a>
        </div>
    </div>
</div>
<div class="faq wf-section">
    <div class="container w-container">
        <h2 class="faq-title">{{aiTrans('Často kladené otázky')}}</h2>
        <p class="faq-text">{{aiTrans('Je veľmi pravdepodobné, že máte ešte niektoré obavy o tom, ako náš obchodný softvér funguje. Ak ste začiatočník, pravdepodobne budete mať aj otázky o tom, ako začať. Tu sú niektoré z najčastejších otázok, ktoré sme dostali od obchodníkov.')}}</p>
        <div class="faq-accordion">
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">1</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Aká je nová verzia [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Nová verzia [website_title] je aktualizovaná verzia populárnej obchodnej platformy pre kryptomeny, navrhnutá na poskytovanie ešte silnejších nástrojov a funkcií, ktoré pomôžu obchodníkom uspieť na trhu kryptomien.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">2</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Aké nové funkcie ponúka nová verzia [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Nová verzia [website_title] ponúka množstvo nových funkcií, vrátane pokročilých nástrojov na správu rizika, trhových dát v reálnom čase, prispôsobiteľných tabuliek a grafov a analýzy správ a udalostí.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">3</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Je nová verzia [website_title] bezpečná na používanie?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Áno, nová verzia [website_title] je bezpečná na používanie. Platforma využíva pokročilé bezpečnostné opatrenia na ochranu údajov a transakcií používateľov a náš tím odborníkov monitoruje platformu 24 hodín denne, 7 dní v týždni, aby zabezpečil jej bezpečnosť a spoľahlivosť.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">4</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Môžem prispôsobiť svoju obchodnú skúsenosť s novou verziou [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Áno, nová verzia [website_title] vám umožňuje prispôsobiť si svoju obchodnú skúsenosť, vrátane prispôsobiteľných tabuliek a grafov, ktoré vám umožnia ľahko zobraziť trhové dáta a trendy.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">5</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Je nová verzia [website_title] vhodná pre začiatočníkov?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Áno, nová verzia [website_title] je vhodná pre začiatočníkov. Platforma je užívateľsky prívetivá a ľahko sa naviguje a náš tím odborníkov je k dispozícii na poskytovanie poradenstva a podpory obchodníkom všetkých úrovní skúseností.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("ZAREGISTROVAŤ SA TERAZ")}}!</a>
        </div>
    </div>
    <div class="faq-bg-2"></div>
    <div class="faq-bg-3"></div>
</div>
<div class="highlights-section wf-section">
    <div class="container w-container">
        <h2 class="faq-title">
            {{ aiTrans(
                "[website_title] Zaujímavosti",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="high-table">
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-1.webp" alt="Zaujímavosti" class="high-img">
                    <div class="high-text">{{aiTrans('Typ')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Obchodný robot AI')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Zaujímavosti" class="high-img">
                    <div class="high-text">{{aiTrans('Cena aplikácie')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Zadarmo')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-3.webp" alt="Zaujímavosti" class="high-img">
                    <div class="high-text">Poplatky</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Nie')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-4.webp" alt="Zaujímavosti" class="high-img">
                    <div class="high-text">{{aiTrans('Demonstrácia účtu')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Áno')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Zaujímavosti" class="high-img">
                    <div class="high-text">{{aiTrans('Aktíva')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('BTC, ETH, XRP, DASH a ďalšie')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-6.webp" alt="Zaujímavosti" class="high-img">
                    <div class="high-text">{{aiTrans('Ochrana údajov používateľa')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Áno')}}</div>


                </div>
            </div>
        </div>
    </div>
</div>
@endsection
