<?php $__env->startSection('title', $website_title .' | 개인정보 보호정책'); ?>
<?php ( $meta_description = "어떻게 ". $website_title."가 개인 데이터를 보호하는지 알아보세요. 우리의 개인정보 보호정책은 귀하의 정보를 안전하게 보호하고 투명하게 관리하기 위한 조치들을 설명합니다."); ?>

<?php $__env->startSection('content'); ?>
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>개인정보 보호정책</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3><?php echo e(aiTrans('1. 서론', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('이 선언은', $locale)); ?> <?php echo e($website_title); ?> ("<?php echo e(aiTrans('우리는', $locale)); ?>," "<?php echo e(aiTrans('우리의', $locale)); ?>," "<?php echo e(aiTrans('또는', $locale)); ?>")
    <?php echo e(aiTrans('우리의 제품 및 서비스(이하 "서비스")와', $locale)); ?> <a href="<?php echo e(route('home',$country)); ?>"><?php echo e(aiTrans('사이트', $locale)); ?></a>
    <?php echo e(aiTrans('("사이트")"에 관한 개인정보 보호정책을 설명합니다.', $locale)); ?> <?php echo e(aiTrans('우리의 서비스와 사이트를 제공할 때 귀하의 개인정보와 기밀성을 보호하는 것이 매우 중요합니다.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('우리의 서비스와 사이트는 제3자의 웹사이트 및 서비스에 대한 링크를 포함할 수 있습니다. 우리는 이들 제3자의 개인정보 보호 관행에 대해 책임지지 않습니다. 이를 사용하기 전에 해당 사이트들의 개인정보 보호정책을 검토할 것을 권장합니다.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('우리가 서비스와 관련하여 수집하는 모든 정보는 기밀로 취급됩니다. 우리는 개인정보(아래 정의된 대로)를 무단 처리, 사고로 인한 손실, 파괴, 손상, 도난 또는 유출로부터 보호하기 위해 강력한 기술적, 보안적, 조직적 조치를 사용합니다.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('당신이 우리 사이트를 통해 정보를 제출하면, 이름, 이메일, 전화번호, 생년월일 및 기타 식별 세부사항과 같은 개인정보를 제공해야 할 수 있습니다. 이러한 정보는 신원 확인, 관리, 기술 지원 제공, 계약 및 법적 의무 이행을 위한 목적으로 사용될 수 있습니다. 중요한 정보를 알림을 통해 전달할 수 있으며, 귀하의 동의를 얻어 SMS, 이메일 등을 통해 제품 및 서비스에 관한 정보를 제공할 수 있습니다. 귀하는 알림 선호 사항을 관리하고 특정 커뮤니케이션을 취소할 수 있는 옵션이 있습니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('2. 사이트; 방문자 및 사용자', $locale)); ?></h3>
<h4><?php echo e(aiTrans('2.1. 일반', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('이 섹션은 웹사이트 방문자("방문자"), 사용자("사용자"), 그리고 비즈니스 파트너(총칭하여 "파트너")의 데이터 수집에 대한 구체적인 사항을 설명합니다. 개인 데이터는 IP 주소, 이름, 연락처 정보, 그리고 당사와의 관계에 대한 정보가 포함되며, 이는 적용 가능한 데이터 보호 규정에 의해 정의됩니다.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('2.2. 데이터 수집 및 사용', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('웹사이트를 방문함으로써 귀하는 귀하의 개인 데이터 수집 및 사용에 동의한 것입니다. 이 조건에 동의하지 않으면 웹사이트를 방문할 수 없습니다. 우리는 페이지 조회 활동, IP 주소 및 쿠키를 통해 정보를 수집할 수 있습니다. 또한, 양식 및 등록을 통해 자발적으로 제공된 데이터를 처리합니다.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('2.3. 개인 데이터 처리 목적', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('우리는 웹사이트와 서비스를 개선하고 이해하며 개인화하기 위해 개인 데이터를 처리합니다. 여기에는 정확성 개선, 서비스에 대한 커뮤니케이션, 지원, 계약 의무 및 파트너와의 협력이 포함됩니다. 동의 또는 법적 근거는 모든 처리에 필수적입니다.', $locale)); ?>

</p>
<p><?php echo e(aiTrans('다음은 개인 데이터 처리 목적과 법적 근거를 설명합니다:', $locale)); ?></p>
<table>
    <tbody>
        <tr>
            <td><?php echo e(aiTrans('계정 소유자 등록', $locale)); ?></td>
            <td><?php echo e(aiTrans('귀하의 동의; 서비스 또는 계약 의무 이행', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('서비스 제공 및 사용', $locale)); ?></td>
            <td><?php echo e(aiTrans('서비스 또는 계약 의무 이행', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('운영 업데이트', $locale)); ?></td>
            <td><?php echo e(aiTrans('서비스 또는 계약 의무 이행', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('문의에 응답하고 지원 제공', $locale)); ?></td>
            <td><?php echo e(aiTrans('정당한 이익 또는 서비스 이행', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('서비스, 광고 및 맞춤형 마케팅', $locale)); ?></td>
            <td><?php echo e(aiTrans('정당한 이익 또는 귀하의 동의', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('서비스 개선 및 새로운 서비스 제공', $locale)); ?></td>
            <td><?php echo e(aiTrans('동의 및 정당한 이익', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('광고 및 마케팅 자료 발송', $locale)); ?></td>
            <td><?php echo e(aiTrans('귀하의 동의', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('마케팅 캠페인 효과 분석', $locale)); ?></td>
            <td><?php echo e(aiTrans('정당한 이익 또는 동의', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('여러 지원 활동 이행', $locale)); ?></td>
            <td><?php echo e(aiTrans('정당한 이익 또는 서비스 이행', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('분석, 통계 분석 포함', $locale)); ?></td>
            <td><?php echo e(aiTrans('정당한 이익', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('이익, 권리 및 자산 보호', $locale)); ?></td>
            <td><?php echo e(aiTrans('정당한 이익 또는 법적 의무', $locale)); ?></td>
        </tr>
    </tbody>
</table>
<h4><?php echo e(aiTrans('2.4. 개인 데이터 공유', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('우리는 서비스 제공업체, 파트너 및 계약자와 정보를 공유할 수 있습니다. 유럽 데이터 지역의 방문자와 사용자에 대해서는 데이터 처리이 GDPR 및 적용 가능한 데이터 보호 법률을 준수합니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('3. 파트너', $locale)); ?></h3>
<h4><?php echo e(aiTrans('3.1. 일반', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('서비스를 제공하고 파트너와 협력하기 위해 우리는 특정 유형의 데이터를 수집하고 처리합니다. 파트너는 자신의 데이터에 대한 책임이 있으며, 우리는 안전한 방법으로 이를 접근할 수 있습니다.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('3.2. 개인 데이터 처리', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('우리는 파트너의 동의나 정당한 이익을 바탕으로 개인 데이터를 처리합니다. 데이터의 집합체는 개발과 품질 향상을 위해 생성될 수 있습니다.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('3.3. 제어자/처리자', $locale)); ?></h4>
<p><?php echo e(aiTrans('우리는 데이터 유형에 따라 제어자 또는 처리자로 활동할 수 있습니다:', $locale)); ?></p>
<ul>
    <li><?php echo e(aiTrans('방문자/사용자 데이터: 제어자', $locale)); ?></li>
    <li><?php echo e(aiTrans('파트너 데이터: 처리자', $locale)); ?></li>
    <li><?php echo e(aiTrans('모든 데이터는 가장 높은 보안 표준을 따르며 안전하게 호스팅됩니다. 우리는 물리적, 기술적, 조직적 보호 조치를 구현합니다.', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('3.4. 제3자의 데이터 보호', $locale)); ?></h4>
<p><?php echo e(aiTrans('서비스가 제3자 플랫폼에서 개인 데이터 처리와 관련이 있는 경우:', $locale)); ?></p>
<ul>
    <li><?php echo e(aiTrans('우리는 처리자로 활동합니다.', $locale)); ?></li>
    <li><?php echo e(aiTrans('제3자의 지침을 준수합니다.', $locale)); ?></li>
    <li><?php echo e(aiTrans('보안 조치를 구현합니다.', $locale)); ?></li>
    <li><?php echo e(aiTrans('데이터 침해에 대해 알립니다.', $locale)); ?></li>
    <li><?php echo e(aiTrans('동의 없이 하청을 주지 않습니다.', $locale)); ?></li>
    <li><?php echo e(aiTrans('유럽 경제 지역 외에서 데이터를 처리하지 않습니다.', $locale)); ?></li>
    <li><?php echo e(aiTrans('전자 마케팅 커뮤니케이션에 대해 우리는 동의 및 취소 옵션을 보장합니다.', $locale)); ?></li>
</ul>
<h3><?php echo e(aiTrans('4. 보안', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('우리는 개인 데이터를 무단 접근, 공개, 변경, 손실, 오용 또는 손상으로부터 보호하기 위해 관리적, 조직적 및 기술적 보호 조치를 사용합니다. 제3자와 데이터를 공유할 때, 우리는 그들이 동일한 데이터 보호 표준을 유지하도록 보장하며, 이 정책에 부합하는 안전한 처리만을 위한 계약상의 의무를 설정합니다.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('만약 우리와의 상호작용이 손상되었다고 믿는다면, 방문자, 사용자 또는 파트너는 즉시 우리에게 알려야 합니다. 우리의 보안 조치에도 불구하고, 제3자의 공격에 대한 완전한 면역을 보장할 수 없다는 점을 유의해야 합니다. 사용자는 내재된 위험과 가능한 침해를 인정합니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('5. 쿠키', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('우리의', $locale)); ?> <a href="<?php echo e(route('home',$country)); ?>"><?php echo e(aiTrans('쿠키 정책', $locale)); ?></a> <?php echo e(aiTrans('을 참조하여 사이트에서 사용되는 쿠키 및 추적 기술의 종류, 사용 이유 및 이를 수락하거나 거부하는 방법에 대한 자세한 정보를 얻을 수 있습니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('6. 다른 사이트로의 링크', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('웹사이트를 탐색하는 동안 사용자는 우리 제어 범위를 벗어난 외부 웹사이트에 대한 링크를 발견할 수 있습니다. 우리는 이러한 사이트의 콘텐츠나 개인정보 보호정책에 대해 책임지지 않습니다. 사용자는 개인정보를 제공하기 전에 해당 사이트 및 제3자 서비스의 개인정보 보호정책을 검토할 것을 권장합니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('7. 보유 및 삭제', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('개인 데이터를 포함한 데이터는 필요한 시간 이상 보유되지 않습니다. 활성 계정을 가진 방문자 및/또는 사용자는 데이터의 적시 삭제에 책임이 있습니다. 계정 또는 파트너십이 종료된 후, 웹사이트 및/또는 서비스에서 수집된 개인 데이터는 해당 법률 및 내부 정책에 따라 삭제됩니다.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('개인 데이터 처리에 대한 동의를 철회하면 요청된 일부 또는 모든 서비스에 대한 접근이 제한될 수 있으며, 이에 대해 불만이나 요구를 제기할 수 없습니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('8. 귀하의 권리', $locale)); ?></h3>
<p><?php echo e(aiTrans('사용자는 개인 데이터와 관련된 특정 권리를 가지고 있습니다:', $locale)); ?></p>
<h4><?php echo e(aiTrans('8.1. 접근 권리', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('개인 데이터가 처리되는지 확인', $locale)); ?></li>
    <li><?php echo e(aiTrans('개인 데이터 및 관련 정보에 접근', $locale)); ?></li>
    <li><?php echo e(aiTrans('처리 목적, 범주, 수신자, 저장 기간, 권리 및 프로파일 존재에 대한 정보', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.2. 수정 권리', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('부정확한 개인 데이터 수정', $locale)); ?></li>
    <li><?php echo e(aiTrans('불완전한 개인 데이터 보완', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.3. 삭제 권리', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('특정 상황에서 개인 데이터 삭제 요청', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.4. 처리 제한 권리', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('특정 상황에서 처리 제한 요청', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.5. 데이터 이동 권리', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('구조화된 기계 판독 형식으로 개인 데이터 수신', $locale)); ?></li>
    <li><?php echo e(aiTrans('개인 데이터를 다른 제어자로 전송', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.6. 반대 권리', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('정당한 이익 또는 직접 마케팅을 기반으로 한 처리 반대', $locale)); ?></li>
    <li><?php echo e(aiTrans('설득력 있고/또는 법적 이유가 없는 한 처리 중지', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.7. 동의 철회 권리', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('개인 데이터 처리에 대한 동의를 언제든지 철회할 수 있습니다.', $locale)); ?></li>
</ul>
<h3><?php echo e(aiTrans('9. 광고 및 마케팅 자료', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('광고 및 마케팅 자료 제공을 위해 개인 데이터와 연락처 세부 정보를 사용하는 데 대한 동의를 받습니다. 동의를 철회하려면 제공된 이메일 주소로 서면 통지를 보내면 됩니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('10. 본 정책의 동의', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('사이트 및/또는 서비스를 사용함으로써 방문자, 사용자 및/또는 파트너는 본 정책을 읽고 동의한 것으로 간주됩니다. 동의하지 않으면 플랫폼 사용을 중단해야 합니다. 우리는 정책을 수정할 권리를 보유하며, 사용자는 주기적으로 업데이트를 확인할 것을 권장합니다. 변경 후 계속 사용하면 동의를 의미합니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('11. 개인 데이터 공개의 법적 의무', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('개인 데이터는 개인의 권리나 재산을 침해할 의혹이 있는 사람에 대해 신원을 확인하거나 연락하거나 법적 절차를 시작해야 할 경우, 사전 동의 없이 공개될 수 있습니다. 공개는 법적으로 요구되는 경우에 이루어집니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('12. 데이터 보호 책임자', $locale)); ?></h3>
            <p>
                <?php echo e(aiTrans('개인 정보 보호 및 데이터 보호 문제에 대해, 지정된 "데이터 보호 책임자"에게 이메일을 통해 연락할 수 있습니다: ', $locale)); ?> <span >info<?php echo e('@'.$website_title); ?></span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>


        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mb/public_html/allone.crizymp.xyz/resources/views/frontend/ko/privacy.blade.php ENDPATH**/ ?>